/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.util.Map;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;

final class LookupInfo {
    private Class<?> type;
    private Map<String, String> names;
    private Map<String, Integer> indices;
    private ObjectConverter<?, ?> converter;

    LookupInfo() {
    }

    final Class<?> getMetadataType() {
        return this.type;
    }

    final void setMetadataType(Class<?> t) {
        if (this.type != t) {
            this.type = t;
            this.names = null;
            this.indices = null;
        }
    }

    final Map<String, String> asNameMap(MetadataStandard standard) {
        if (this.names == null) {
            this.names = standard.asNameMap(this.type, KeyNamePolicy.METHOD_NAME, MetadataSource.NAME_POLICY);
        }
        return this.names;
    }

    final Map<String, Integer> asIndexMap(MetadataStandard standard) {
        if (this.indices == null) {
            this.indices = standard.asIndexMap(this.type, KeyNamePolicy.METHOD_NAME);
        }
        return this.indices;
    }

    final Object convert(Class<?> targetType, Object value) {
        Class<?> sourceType = value.getClass();
        if (!targetType.isAssignableFrom(sourceType)) {
            if (this.converter == null || !this.converter.getSourceClass().isAssignableFrom(sourceType) || !targetType.isAssignableFrom(this.converter.getTargetClass())) {
                this.converter = ObjectConverters.find(sourceType, targetType);
            }
            value = this.converter.apply(value);
        }
        return value;
    }
}

