/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.serializer.FormatterTemplate;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class Template {
    static final int HashTemplateGroup = 177;
    private final QuadAcc qp;
    private final BasicPattern bgp;
    private int calcHashCode = -1;

    public Template(QuadAcc qp) {
        this.qp = qp;
        this.bgp = null;
    }

    public Template(BasicPattern bgp) {
        this.bgp = bgp;
        this.qp = null;
    }

    public boolean containsRealQuad() {
        for (Quad quad : this.getQuads()) {
            if (Quad.defaultGraphNodeGenerated.equals(quad.getGraph())) continue;
            return true;
        }
        return false;
    }

    public BasicPattern getBGP() {
        if (this.bgp != null) {
            return this.bgp;
        }
        BasicPattern bgp = new BasicPattern();
        for (Quad q : this.qp.getQuads()) {
            if (!Quad.defaultGraphNodeGenerated.equals(q.getGraph())) continue;
            bgp.add(q.asTriple());
        }
        return bgp;
    }

    public List<Triple> getTriples() {
        if (this.bgp != null) {
            return this.bgp.getList();
        }
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (Quad q : this.qp.getQuads()) {
            if (!Quad.defaultGraphNodeGenerated.equals(q.getGraph())) continue;
            triples.add(q.asTriple());
        }
        return triples;
    }

    public List<Quad> getQuads() {
        if (this.bgp != null) {
            ArrayList<Quad> quads = new ArrayList<Quad>();
            for (Triple triple : this.bgp.getList()) {
                quads.add(Quad.create(Quad.defaultGraphNodeGenerated, triple));
            }
            return quads;
        }
        return this.qp.getQuads();
    }

    public Map<Node, BasicPattern> getGraphPattern() {
        List<Quad> quads = this.getQuads();
        HashMap<Node, BasicPattern> graphs = new HashMap<Node, BasicPattern>();
        for (Quad q : quads) {
            BasicPattern bgp = graphs.get(q.getGraph());
            if (bgp == null) {
                bgp = new BasicPattern();
                graphs.put(q.getGraph(), bgp);
            }
            bgp.add(q.asTriple());
        }
        return graphs;
    }

    public int hashCode() {
        int calcHashCode = 177;
        for (Quad q : this.getQuads()) {
            calcHashCode ^= Template.hash(q) ^ calcHashCode << 1;
        }
        return calcHashCode;
    }

    private static int hash(Quad quad) {
        int hash = 0;
        hash = Template.hashNode(quad.getSubject()) ^ hash << 1;
        hash = Template.hashNode(quad.getPredicate()) ^ hash << 1;
        hash = Template.hashNode(quad.getObject()) ^ hash << 1;
        hash = Template.hashGraph(quad.getGraph()) ^ hash << 1;
        return hash;
    }

    private static int hashGraph(Node node) {
        if (node == null) {
            return Quad.defaultGraphNodeGenerated.hashCode();
        }
        if (node.isBlank()) {
            return 59;
        }
        return node.hashCode();
    }

    private static int hashNode(Node node) {
        if (node == null) {
            return 37;
        }
        if (node.isBlank()) {
            return 59;
        }
        return node.hashCode();
    }

    public boolean equalIso(Object temp2, NodeIsomorphismMap labelMap) {
        if (!(temp2 instanceof Template)) {
            return false;
        }
        Template tg2 = (Template)temp2;
        List<Quad> list1 = this.getQuads();
        List<Quad> list2 = tg2.getQuads();
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            Quad q2;
            Quad q1 = list1.get(i);
            boolean iso = Iso.quadIso(q1, q2 = list2.get(i), labelMap);
            if (iso) continue;
            return false;
        }
        return true;
    }

    public void format(FormatterTemplate fmtTemplate) {
        fmtTemplate.format(this);
    }
}

