/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.shiro;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.mod.shiro.FusekiShiro;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.env.ResourceBasedWebEnvironment;
import org.apache.shiro.web.env.WebEnvironment;

class ShiroEnvironmentLoaderListener
extends EnvironmentLoaderListener {
    private List<String> locations;

    ShiroEnvironmentLoaderListener(List<String> locations) {
        this.locations = locations;
    }

    @Override
    protected void customizeEnvironment(WebEnvironment environment) {
        if (this.locations == null) {
            return;
        }
        if (environment instanceof ResourceBasedWebEnvironment) {
            ResourceBasedWebEnvironment env = (ResourceBasedWebEnvironment)environment;
            String[] configLocations = env.getConfigLocations();
            if (configLocations != null && configLocations.length > 0) {
                FmtLog.info(FusekiShiro.shiroLog, "Shiro file resource %s", Arrays.asList(configLocations));
                return;
            }
            String loc = FusekiShiro.huntForShiroIni(this.locations);
            if (loc == null) {
                FmtLog.info(FusekiShiro.shiroLog, "No Shiro file found (tried: %s)", this.locations);
                return;
            }
            String[] configLocationsHere = new String[]{loc};
            env.setConfigLocations(configLocationsHere);
        }
    }
}

