/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.WSLSMS;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

final class WSLSMSR<K, V>
extends WSLSMS<K, V> {
    static final LocalCacheFactory FACTORY = WSLSMSR::new;
    private static final VarHandle REFRESH_AFTER_WRITE_NANOS;
    final Ticker ticker;
    volatile long refreshAfterWriteNanos;

    WSLSMSR(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.setRefreshAfterWriteNanos(caffeine.getRefreshAfterWriteNanos());
    }

    @Override
    public Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected boolean refreshAfterWrite() {
        return true;
    }

    @Override
    protected long refreshAfterWriteNanos() {
        return REFRESH_AFTER_WRITE_NANOS.getAcquire(this);
    }

    @Override
    protected void setRefreshAfterWriteNanos(long l) {
        REFRESH_AFTER_WRITE_NANOS.setRelease(this, l);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            REFRESH_AFTER_WRITE_NANOS = lookup.findVarHandle(WSLSMSR.class, "refreshAfterWriteNanos", Long.TYPE);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

