/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.Collection;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AccessLogFieldRequestControl
extends Control {
    @NotNull
    public static final String ACCESS_LOG_FIELD_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.66";
    private static final long serialVersionUID = 6329096464063641398L;
    @NotNull
    private final JSONObject fieldsObject;

    public AccessLogFieldRequestControl(JSONField ... fields) throws LDAPException {
        this(false, fields);
    }

    public AccessLogFieldRequestControl(@NotNull Collection<JSONField> fields) throws LDAPException {
        this(false, fields);
    }

    public AccessLogFieldRequestControl(boolean isCritical, JSONField ... fields) throws LDAPException {
        this(isCritical, new JSONObject(fields));
    }

    public AccessLogFieldRequestControl(boolean isCritical, @NotNull Collection<JSONField> fields) throws LDAPException {
        this(isCritical, new JSONObject(StaticUtils.toArray(fields, JSONField.class)));
    }

    public AccessLogFieldRequestControl(boolean isCritical, @NotNull JSONObject fieldsObject) throws LDAPException {
        super(ACCESS_LOG_FIELD_REQUEST_OID, isCritical, new ASN1OctetString(fieldsObject.toString()));
        this.fieldsObject = fieldsObject;
        AccessLogFieldRequestControl.validateFields(fieldsObject);
    }

    private static void validateFields(@NotNull JSONObject o) throws LDAPException {
        Map<String, JSONValue> fields = o.getFields();
        if (fields.isEmpty()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ControlMessages.ERR_ACCESS_LOG_FIELD_REQUEST_NO_FIELDS.get());
        }
        for (Map.Entry<String, JSONValue> e : fields.entrySet()) {
            String fieldName = e.getKey();
            if (fieldName.isEmpty()) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ControlMessages.ERR_ACCESS_LOG_FIELD_REQUEST_EMPTY_FIELD_NAME.get());
            }
            for (char c : fieldName.toCharArray()) {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
                throw new LDAPException(ResultCode.PARAM_ERROR, ControlMessages.ERR_ACCESS_LOG_FIELD_REQUEST_INVALID_FIELD_NAME.get(fieldName));
            }
            JSONValue fieldValue = e.getValue();
            if (fieldValue instanceof JSONBoolean || fieldValue instanceof JSONNumber || fieldValue instanceof JSONString) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, ControlMessages.ERR_ACCESS_LOG_FIELD_REQUEST_INVALID_FIELD_TYPE.get(fieldName));
        }
    }

    public AccessLogFieldRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (!control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCESS_LOG_FIELD_REQUEST_DECODE_NO_VALUE.get());
        }
        try {
            this.fieldsObject = new JSONObject(control.getValue().stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCESS_LOG_FIELD_REQUEST_DECODE_VALUE_NOT_JSON.get());
        }
        try {
            AccessLogFieldRequestControl.validateFields(this.fieldsObject);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_ACCESS_LOG_FIELD_REQUEST_DECODE_VALUE_UNACCEPTABLE_FIELDS.get(e.getMessage()), e);
        }
    }

    @NotNull
    public JSONObject getFieldsObject() {
        return this.fieldsObject;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ACCESS_LOG_FIELD_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", ACCESS_LOG_FIELD_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_ACCESS_LOG_FIELD_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", this.fieldsObject));
    }

    @NotNull
    public static AccessLogFieldRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new AccessLogFieldRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        return new AccessLogFieldRequestControl(jsonControl.getCriticality(), jsonControl.getValueObject());
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AccessLogFieldRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", fields=");
        buffer.append(this.fieldsObject.toSingleLineString());
        buffer.append(')');
    }
}

