/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.event.acl;

import java.util.Objects;
import org.apache.james.event.MailboxAggregateId;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.model.MailboxId;

public class ACLUpdated
implements Event {
    private final MailboxAggregateId id;
    private final EventId eventId;
    private final ACLDiff aclDiff;

    public ACLUpdated(MailboxAggregateId id, EventId eventId, ACLDiff aclDiff) {
        this.id = id;
        this.eventId = eventId;
        this.aclDiff = aclDiff;
    }

    public MailboxId mailboxId() {
        return this.id.asMailboxId();
    }

    public EventId eventId() {
        return this.eventId;
    }

    public AggregateId getAggregateId() {
        return this.id;
    }

    public ACLDiff getAclDiff() {
        return this.aclDiff;
    }

    public final boolean equals(Object o) {
        if (o instanceof ACLUpdated) {
            ACLUpdated that = (ACLUpdated)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.id, that.id) && Objects.equals(this.aclDiff, that.aclDiff);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.eventId, this.id, this.aclDiff);
    }
}

