/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import jakarta.inject.Inject;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.ConnectionDescription;
import org.apache.james.core.ConnectionDescriptionSupplier;
import org.apache.james.core.Disconnector;
import org.apache.james.core.Username;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.library.netmatcher.NetMatcher;
import org.apache.james.protocols.api.CommandDetectionSession;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.lib.handler.HandlersPackage;
import org.apache.james.protocols.lib.netty.AbstractProtocolAsyncServer;
import org.apache.james.protocols.netty.AllButStartTlsLineChannelHandlerFactory;
import org.apache.james.protocols.netty.BasicChannelInboundHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.smtp.SMTPConfiguration;
import org.apache.james.protocols.smtp.SMTPProtocol;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.smtpserver.CoreCmdHandlerLoader;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.smtpserver.jmx.JMXHandlersLoader;
import org.apache.james.smtpserver.netty.SMTPChannelInboundHandler;
import org.apache.james.smtpserver.netty.SMTPServerMBean;
import org.apache.james.smtpserver.netty.SmtpMetrics;
import org.apache.james.util.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPServer
extends AbstractProtocolAsyncServer
implements SMTPServerMBean,
Disconnector,
ConnectionDescriptionSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMTPServer.class);
    private SMTPProtocol transport;
    private AuthenticationConfiguration authenticationConfiguration;
    private boolean heloEhloEnforcement = false;
    private String smtpGreeting = null;
    private NetMatcher authorizedNetworks = null;
    private long maxMessageSize = 0L;
    private final SMTPConfiguration theConfigData = new SMTPHandlerConfigurationDataImpl();
    private final SmtpMetrics smtpMetrics;
    private final DefaultChannelGroup smtpChannelGroup;
    private Set<String> disabledFeatures = ImmutableSet.of();
    private boolean addressBracketsEnforcement = true;
    private SMTPConfiguration.SenderVerificationMode verifyIdentity;
    private DNSService dns;
    private String authorizedAddresses;

    public SMTPServer(SmtpMetrics smtpMetrics) {
        this.smtpMetrics = smtpMetrics;
        this.smtpChannelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    @Inject
    public void setDnsService(DNSService dns) {
        this.dns = dns;
    }

    protected void preInit() throws Exception {
        super.preInit();
        if (this.authorizedAddresses != null) {
            StringTokenizer st = new StringTokenizer(this.authorizedAddresses, ", ", false);
            ArrayList<String> networks = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String addr = st.nextToken();
                networks.add(addr);
            }
            this.authorizedNetworks = new NetMatcher(networks, this.dns);
            LOGGER.info("Authorized addresses: {}", (Object)this.authorizedNetworks);
        }
        this.transport = new SMTPProtocol(this.getProtocolHandlerChain(), this.theConfigData){

            public ProtocolSession newSession(ProtocolTransport transport) {
                return new ExtendedSMTPSession(SMTPServer.this.theConfigData, transport);
            }
        };
    }

    public void doConfigure(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
        super.doConfigure(configuration);
        if (this.isEnabled()) {
            this.authenticationConfiguration = AuthenticationConfiguration.parse(configuration);
            this.authorizedAddresses = configuration.getString("authorizedAddresses", null);
            this.maxMessageSize = Size.parse((String)configuration.getString("maxmessagesize", "0"), (Size.Unit)Size.Unit.K).asBytes();
            if (this.maxMessageSize > 0L) {
                LOGGER.info("The maximum allowed message size is {} bytes.", (Object)this.maxMessageSize);
            } else {
                LOGGER.info("No maximum message size is enforced for this server.");
            }
            this.heloEhloEnforcement = configuration.getBoolean("heloEhloEnforcement", true);
            this.smtpGreeting = configuration.getString("smtpGreeting", null);
            this.addressBracketsEnforcement = configuration.getBoolean("addressBracketsEnforcement", true);
            this.verifyIdentity = SMTPConfiguration.SenderVerificationMode.parse((String)configuration.getString("verifyIdentity", "strict"));
            this.disabledFeatures = ImmutableSet.copyOf((Object[])configuration.getStringArray("disabledFeatures"));
        }
    }

    protected int getDefaultPort() {
        return 25;
    }

    public String getServiceType() {
        return "SMTP Service";
    }

    @Override
    public long getMaximalMessageSize() {
        return this.maxMessageSize;
    }

    @Override
    public boolean getAddressBracketsEnforcement() {
        return this.addressBracketsEnforcement;
    }

    @Override
    public boolean getHeloEhloEnforcement() {
        return this.heloEhloEnforcement;
    }

    protected String getDefaultJMXName() {
        return "smtpserver";
    }

    @Override
    public void setMaximalMessageSize(long maxSize) {
        this.maxMessageSize = maxSize;
    }

    @Override
    public void setAddressBracketsEnforcement(boolean enforceAddressBrackets) {
        this.addressBracketsEnforcement = enforceAddressBrackets;
    }

    @Override
    public void setHeloEhloEnforcement(boolean enforceHeloEHlo) {
        this.heloEhloEnforcement = enforceHeloEHlo;
    }

    @Override
    public String getHeloName() {
        return this.theConfigData.getHelloName();
    }

    protected ChannelInboundHandlerAdapter createCoreHandler() {
        return new SMTPChannelInboundHandler((Protocol)this.transport, this.getEncryption(), this.proxyRequired, this.smtpMetrics, (ChannelGroup)this.smtpChannelGroup);
    }

    protected Class<? extends HandlersPackage> getCoreHandlersPackage() {
        return CoreCmdHandlerLoader.class;
    }

    protected Class<? extends HandlersPackage> getJMXHandlersPackage() {
        return JMXHandlersLoader.class;
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new AllButStartTlsLineChannelHandlerFactory("starttls", 8192);
    }

    public AuthenticationAnnounceMode getAuthRequired() {
        return this.authenticationConfiguration.getAuthenticationAnnounceMode();
    }

    public void disconnect(Predicate<Username> user) {
        this.smtpChannelGroup.stream().filter(channel -> {
            Object patt0$temp = channel.attr(BasicChannelInboundHandler.SESSION_ATTRIBUTE_KEY).get();
            if (patt0$temp instanceof SMTPSession) {
                SMTPSession smtpSession = (SMTPSession)patt0$temp;
                return user.test(smtpSession.getUsername());
            }
            return false;
        }).forEach(channel -> channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
    }

    public Stream<ConnectionDescription> describeConnections() {
        return this.smtpChannelGroup.stream().map(channel -> {
            Optional<ProtocolSession> pSession = Optional.ofNullable((CommandDetectionSession)channel.attr(BasicChannelInboundHandler.SESSION_ATTRIBUTE_KEY).get()).map(session -> (ProtocolSession)session);
            return new ConnectionDescription("SMTP", this.jmxName, Optional.ofNullable(channel.remoteAddress()).map(this::addressAsString), Optional.ofNullable(channel.attr(BasicChannelInboundHandler.CONNECTION_DATE)).flatMap(attribute -> Optional.ofNullable((Instant)attribute.get())), channel.isActive(), channel.isOpen(), channel.isWritable(), pSession.map(p -> p.getSSLSession().isPresent()).orElse(false).booleanValue(), pSession.flatMap(session -> Optional.ofNullable(session.getUsername())), (Map)ImmutableMap.of());
        });
    }

    private String addressAsString(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)socketAddress;
            return address.getAddress().getHostAddress();
        }
        return socketAddress.toString();
    }

    public class SMTPHandlerConfigurationDataImpl
    implements SMTPConfiguration {
        public String getHelloName() {
            return SMTPServer.this.getHelloName();
        }

        public long getMaxMessageSize() {
            return SMTPServer.this.maxMessageSize;
        }

        public boolean isRelayingAllowed(String remoteIP) {
            if (SMTPServer.this.authorizedNetworks != null) {
                return SMTPServer.this.authorizedNetworks.matchInetNetwork(remoteIP);
            }
            return false;
        }

        public boolean useHeloEhloEnforcement() {
            return SMTPServer.this.heloEhloEnforcement;
        }

        public boolean useAddressBracketsEnforcement() {
            return SMTPServer.this.addressBracketsEnforcement;
        }

        public boolean isPlainAuthEnabled() {
            return SMTPServer.this.authenticationConfiguration.isPlainAuthEnabled();
        }

        public boolean isAuthAnnounced(String remoteIP, boolean tlsStarted) {
            if (SMTPServer.this.authenticationConfiguration.requireSSL && !tlsStarted) {
                return false;
            }
            if (SMTPServer.this.authenticationConfiguration.getAuthenticationAnnounceMode() == AuthenticationAnnounceMode.ALWAYS) {
                return true;
            }
            if (SMTPServer.this.authenticationConfiguration.getAuthenticationAnnounceMode() == AuthenticationAnnounceMode.NEVER) {
                return false;
            }
            return Optional.ofNullable(SMTPServer.this.authorizedNetworks).map(nets -> !nets.matchInetNetwork(remoteIP)).orElse(true);
        }

        public SMTPConfiguration.SenderVerificationMode verifyIdentity() {
            return SMTPServer.this.verifyIdentity;
        }

        public String getGreeting() {
            return SMTPServer.this.smtpGreeting;
        }

        public String getSoftwareName() {
            return "JAMES SMTP Server ";
        }

        public Optional<OidcSASLConfiguration> saslConfiguration() {
            return SMTPServer.this.authenticationConfiguration.getSaslConfiguration();
        }

        public Set<String> disabledFeatures() {
            return SMTPServer.this.disabledFeatures;
        }
    }

    public static class AuthenticationConfiguration {
        private static final String OIDC_PATH = "auth.oidc";
        private final AuthenticationAnnounceMode authenticationAnnounceMode;
        private final boolean requireSSL;
        private final boolean plainAuthEnabled;
        private final Optional<OidcSASLConfiguration> saslConfiguration;

        public static AuthenticationConfiguration parse(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
            return new AuthenticationConfiguration(Optional.ofNullable(configuration.getString("auth.announce", null)).map(AuthenticationAnnounceMode::parse).orElseGet(() -> AuthenticationConfiguration.fallbackAuthenticationAnnounceMode(configuration)), configuration.getBoolean("auth.requireSSL", false), configuration.getBoolean("auth.plainAuthEnabled", true), AuthenticationConfiguration.parseSASLConfiguration(configuration));
        }

        private static Optional<OidcSASLConfiguration> parseSASLConfiguration(HierarchicalConfiguration<ImmutableNode> configuration) throws ConfigurationException {
            boolean haveOidcProperties = configuration.getKeys(OIDC_PATH).hasNext();
            if (haveOidcProperties) {
                try {
                    return Optional.of(OidcSASLConfiguration.parse((HierarchicalConfiguration)configuration.configurationAt(OIDC_PATH)));
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    throw new ConfigurationException("Failed to retrieve oauth component", (Throwable)exception);
                }
            }
            return Optional.empty();
        }

        private static AuthenticationAnnounceMode fallbackAuthenticationAnnounceMode(HierarchicalConfiguration<ImmutableNode> configuration) {
            return AuthenticationAnnounceMode.parseFallback(configuration.getString("authRequired", "false"));
        }

        public AuthenticationConfiguration(AuthenticationAnnounceMode authenticationAnnounceMode, boolean requireSSL, boolean plainAuthEnabled, Optional<OidcSASLConfiguration> saslConfiguration) {
            this.authenticationAnnounceMode = authenticationAnnounceMode;
            this.requireSSL = requireSSL;
            this.plainAuthEnabled = plainAuthEnabled;
            this.saslConfiguration = saslConfiguration;
        }

        public AuthenticationAnnounceMode getAuthenticationAnnounceMode() {
            return this.authenticationAnnounceMode;
        }

        public boolean isRequireSSL() {
            return this.requireSSL;
        }

        public boolean isPlainAuthEnabled() {
            return this.plainAuthEnabled;
        }

        public Optional<OidcSASLConfiguration> getSaslConfiguration() {
            return this.saslConfiguration;
        }
    }

    public static enum AuthenticationAnnounceMode {
        NEVER,
        FOR_UNAUTHORIZED_ADDRESSES,
        ALWAYS;


        public static AuthenticationAnnounceMode parseFallback(String authRequiredString) {
            String sanitized = authRequiredString.trim().toLowerCase(Locale.US);
            if (sanitized.equals("true")) {
                return FOR_UNAUTHORIZED_ADDRESSES;
            }
            if (sanitized.equals("announce")) {
                return ALWAYS;
            }
            return NEVER;
        }

        public static AuthenticationAnnounceMode parse(String authRequiredString) {
            String sanitized;
            switch (sanitized = authRequiredString.trim().toLowerCase(Locale.US)) {
                case "forunauthorizedaddresses": {
                    return FOR_UNAUTHORIZED_ADDRESSES;
                }
                case "always": {
                    return ALWAYS;
                }
                case "never": {
                    return NEVER;
                }
            }
            throw new RuntimeException("Unknown value for 'auth.announce': " + authRequiredString + ". Should be one of always, never, forUnauthorizedAddresses");
        }
    }
}

