/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.filescan.model;

import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractChunkOffset;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AbstractDeviceChunkMetaData;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.model.AlignedChunkOffset;
import org.apache.iotdb.db.storageengine.dataregion.utils.SharedTimeDataBuffer;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;

public class AlignedDeviceChunkMetaData
extends AbstractDeviceChunkMetaData {
    private int alignedChunkMetadataIndex;
    private int valueChunkMetadataIndex;
    private int curValueSize;
    private final List<AlignedChunkMetadata> alignedChunkMetadataList;

    public AlignedDeviceChunkMetaData(IDeviceID devicePath, List<AlignedChunkMetadata> alignedChunkMetadataList) {
        super(devicePath);
        this.alignedChunkMetadataList = alignedChunkMetadataList;
        this.alignedChunkMetadataIndex = 0;
        this.curValueSize = alignedChunkMetadataList.get(0).getValueChunkMetadataList().size();
        this.valueChunkMetadataIndex = -1;
    }

    @Override
    public boolean hasNextValueChunkMetadata() {
        return this.alignedChunkMetadataIndex < this.alignedChunkMetadataList.size() - 1 || this.valueChunkMetadataIndex < this.curValueSize - 1;
    }

    @Override
    public IChunkMetadata nextValueChunkMetadata() {
        if (this.valueChunkMetadataIndex < this.curValueSize - 1) {
            ++this.valueChunkMetadataIndex;
        } else {
            ++this.alignedChunkMetadataIndex;
            this.valueChunkMetadataIndex = 0;
            this.curValueSize = this.alignedChunkMetadataList.get(this.alignedChunkMetadataIndex).getValueChunkMetadataList().size();
        }
        return (IChunkMetadata)this.alignedChunkMetadataList.get(this.alignedChunkMetadataIndex).getValueChunkMetadataList().get(this.valueChunkMetadataIndex);
    }

    @Override
    public AbstractChunkOffset getChunkOffset() {
        AlignedChunkMetadata alignedChunkMetadata = this.alignedChunkMetadataList.get(this.alignedChunkMetadataIndex);
        IChunkMetadata valueChunkMetaData = (IChunkMetadata)alignedChunkMetadata.getValueChunkMetadataList().get(this.valueChunkMetadataIndex);
        return new AlignedChunkOffset(valueChunkMetaData.getOffsetOfChunkHeader(), this.getDevicePath(), valueChunkMetaData.getMeasurementUid(), new SharedTimeDataBuffer(alignedChunkMetadata.getTimeChunkMetadata()));
    }
}

