/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.airgap;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.sink.limiter.TsFileSendRateLimiter;
import org.apache.iotdb.commons.pipe.sink.protocol.IoTDBAirGapSink;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.terminate.PipeTerminateEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeResourceMetrics;
import org.apache.iotdb.db.pipe.metric.sink.PipeDataRegionSinkMetrics;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFilePieceReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFileSealReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFileSealWithModReq;
import org.apache.iotdb.db.pipe.sink.protocol.airgap.IoTDBDataNodeAirGapSink;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataRegionAirGapSink
extends IoTDBDataNodeAirGapSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionAirGapSink.class);
    private boolean enableSendTsFileLimit;

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        this.enableSendTsFileLimit = parameters.getBooleanOrDefault(Arrays.asList("sink.enable-send-tsfile-limit", "connector.enable-send-tsfile-limit"), false);
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBDataRegionAirGapConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Ignore {}.", (Object)tabletInsertionEvent);
            return;
        }
        int socketIndex = this.nextSocketIndex();
        IoTDBAirGapSink.AirGapSocket socket = (IoTDBAirGapSink.AirGapSocket)this.sockets.get(socketIndex);
        try {
            if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                this.doTransferWrapper(socket, (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
            } else {
                this.doTransferWrapper(socket, (PipeRawTabletInsertionEvent)tabletInsertionEvent);
            }
        }
        catch (IOException e) {
            this.isSocketAlive.set(socketIndex, false);
            throw new PipeConnectionException(String.format("Network error when transfer tablet insertion event %s, because %s.", ((EnrichedEvent)tabletInsertionEvent).coreReportMessage(), e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBDataRegionAirGapConnector only support PipeTsFileInsertionEvent. Ignore {}.", (Object)tsFileInsertionEvent);
            return;
        }
        if (!((PipeTsFileInsertionEvent)tsFileInsertionEvent).waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)((PipeTsFileInsertionEvent)tsFileInsertionEvent).getTsFile());
            return;
        }
        int socketIndex = this.nextSocketIndex();
        IoTDBAirGapSink.AirGapSocket socket = (IoTDBAirGapSink.AirGapSocket)this.sockets.get(socketIndex);
        try {
            this.doTransferWrapper(socket, (PipeTsFileInsertionEvent)tsFileInsertionEvent);
        }
        catch (IOException e) {
            this.isSocketAlive.set(socketIndex, false);
            throw new PipeConnectionException(String.format("Network error when transfer tsfile insertion event %s, because %s.", ((PipeTsFileInsertionEvent)tsFileInsertionEvent).coreReportMessage(), e.getMessage()), (Throwable)e);
        }
    }

    public void transfer(Event event) throws Exception {
        int socketIndex = this.nextSocketIndex();
        IoTDBAirGapSink.AirGapSocket socket = (IoTDBAirGapSink.AirGapSocket)this.sockets.get(socketIndex);
        try {
            if (event instanceof PipeSchemaRegionWritePlanEvent) {
                this.doTransferWrapper(socket, (PipeSchemaRegionWritePlanEvent)event);
            } else if (!(event instanceof PipeHeartbeatEvent) && !(event instanceof PipeTerminateEvent)) {
                LOGGER.warn("IoTDBDataRegionAirGapConnector does not support transferring generic event: {}.", (Object)event);
            }
        }
        catch (IOException e) {
            this.isSocketAlive.set(socketIndex, false);
            throw new PipeConnectionException(String.format("Network error when transfer tsfile event %s, because %s.", ((PipeSchemaRegionWritePlanEvent)event).coreReportMessage(), e.getMessage()), (Throwable)e);
        }
    }

    private void doTransferWrapper(IoTDBAirGapSink.AirGapSocket socket, PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException, WALPipeException, IOException {
        if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(IoTDBDataRegionAirGapSink.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeInsertNodeTabletInsertionEvent);
        }
        finally {
            pipeInsertNodeTabletInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAirGapSink.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapSink.AirGapSocket socket, PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws PipeException, WALPipeException, IOException {
        byte[] bytes;
        InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNode();
        byte[] byArray = bytes = Objects.isNull(insertNode) ? PipeTransferTabletBinaryReq.toTPipeTransferBytes(pipeInsertNodeTabletInsertionEvent.getByteBuffer()) : PipeTransferTabletInsertNodeReq.toTPipeTransferBytes(insertNode);
        if (!this.send(pipeInsertNodeTabletInsertionEvent.getPipeName(), pipeInsertNodeTabletInsertionEvent.getCreationTime(), socket, bytes)) {
            String errorMessage = String.format("Transfer PipeInsertNodeTabletInsertionEvent %s error. Socket: %s", pipeInsertNodeTabletInsertionEvent, socket);
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeInsertNodeTabletInsertionEvent.toString());
        }
    }

    private void doTransferWrapper(IoTDBAirGapSink.AirGapSocket socket, PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException, IOException {
        if (!pipeRawTabletInsertionEvent.increaseReferenceCount(IoTDBDataRegionAirGapSink.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeRawTabletInsertionEvent);
        }
        finally {
            pipeRawTabletInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAirGapSink.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapSink.AirGapSocket socket, PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws PipeException, IOException {
        if (!this.send(pipeRawTabletInsertionEvent.getPipeName(), pipeRawTabletInsertionEvent.getCreationTime(), socket, PipeTransferTabletRawReq.toTPipeTransferBytes(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned()))) {
            String errorMessage = String.format("Transfer PipeRawTabletInsertionEvent %s error. Socket: %s.", pipeRawTabletInsertionEvent, socket);
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeRawTabletInsertionEvent.toString());
        }
    }

    private void doTransferWrapper(IoTDBAirGapSink.AirGapSocket socket, PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, IOException {
        if (!pipeTsFileInsertionEvent.increaseReferenceCount(IoTDBDataRegionAirGapSink.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeTsFileInsertionEvent);
        }
        finally {
            pipeTsFileInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAirGapSink.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapSink.AirGapSocket socket, PipeTsFileInsertionEvent pipeTsFileInsertionEvent) throws PipeException, IOException {
        String pipeName = pipeTsFileInsertionEvent.getPipeName();
        long creationTime = pipeTsFileInsertionEvent.getCreationTime();
        File tsFile = pipeTsFileInsertionEvent.getTsFile();
        String errorMessage = String.format("Seal file %s error. Socket %s.", tsFile, socket);
        if (pipeTsFileInsertionEvent.isWithMod() && this.supportModsIfIsDataNodeReceiver) {
            File modFile = pipeTsFileInsertionEvent.getModFile();
            this.transferFilePieces(pipeName, creationTime, modFile, socket, true);
            this.transferFilePieces(pipeName, creationTime, tsFile, socket, true);
            if (!this.send(pipeName, creationTime, socket, PipeTransferTsFileSealWithModReq.toTPipeTransferBytes(modFile.getName(), modFile.length(), tsFile.getName(), tsFile.length()))) {
                this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeTsFileInsertionEvent.toString());
            } else {
                LOGGER.info("Successfully transferred file {}.", (Object)tsFile);
            }
        } else {
            this.transferFilePieces(pipeName, creationTime, tsFile, socket, false);
            if (!this.send(pipeName, creationTime, socket, PipeTransferTsFileSealReq.toTPipeTransferBytes(tsFile.getName(), tsFile.length()))) {
                this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeTsFileInsertionEvent.toString());
            } else {
                LOGGER.info("Successfully transferred file {}.", (Object)tsFile);
            }
        }
    }

    protected void mayLimitRateAndRecordIO(long requiredBytes) {
        PipeResourceMetrics.getInstance().recordDiskIO(requiredBytes);
        if (this.enableSendTsFileLimit) {
            TsFileSendRateLimiter.getInstance().acquire(requiredBytes);
        }
    }

    protected byte[] getTransferSingleFilePieceBytes(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferTsFilePieceReq.toTPipeTransferBytes(fileName, position, payLoad);
    }

    protected byte[] getTransferMultiFilePieceBytes(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferTsFilePieceWithModReq.toTPipeTransferBytes(fileName, position, payLoad);
    }

    protected byte[] compressIfNeeded(byte[] reqInBytes) throws IOException {
        if (Objects.isNull(this.compressionTimer) && Objects.nonNull(this.attributeSortedString)) {
            this.compressionTimer = PipeDataRegionSinkMetrics.getInstance().getCompressionTimer(this.attributeSortedString);
        }
        return super.compressIfNeeded(reqInBytes);
    }
}

