/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.scheduler.load;

import io.airlift.units.Duration;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.ExecutorType;
import org.apache.iotdb.commons.partition.StorageExecutor;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.exception.load.LoadReadOnlyException;
import org.apache.iotdb.db.exception.load.RegionReplicaSetChangedException;
import org.apache.iotdb.db.exception.mpp.FragmentInstanceDispatchException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.PlanFragmentId;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.PlanFragment;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadTsFilePieceNode;
import org.apache.iotdb.db.queryengine.plan.scheduler.FragInstanceDispatchResult;
import org.apache.iotdb.db.queryengine.plan.scheduler.IScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.load.LoadTsFileDispatcherImpl;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.service.RegionMigrateService;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.load.converter.LoadTsFileDataTypeConverter;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileDataCacheMemoryBlock;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileMemoryManager;
import org.apache.iotdb.db.storageengine.load.metrics.LoadTsFileCostMetricsSet;
import org.apache.iotdb.db.storageengine.load.splitter.ChunkData;
import org.apache.iotdb.db.storageengine.load.splitter.TsFileData;
import org.apache.iotdb.db.storageengine.load.splitter.TsFileSplitter;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.mpp.rpc.thrift.TLoadCommandReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.PublicBAOS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileScheduler
implements IScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileScheduler.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private static final LoadTsFileCostMetricsSet LOAD_TSFILE_COST_METRICS_SET = LoadTsFileCostMetricsSet.getInstance();
    private static final long SINGLE_SCHEDULER_MAX_MEMORY_SIZE = IoTDBDescriptor.getInstance().getConfig().getThriftMaxFrameSize() >> 2;
    private static final int TRANSMIT_LIMIT = CommonDescriptor.getInstance().getConfig().getTTimePartitionSlotTransmitLimit();
    private static final Set<String> LOADING_FILE_SET = new HashSet<String>();
    private final MPPQueryContext queryContext;
    private final QueryStateMachine stateMachine;
    private final LoadTsFileDispatcherImpl dispatcher;
    private final DataPartitionBatchFetcher partitionFetcher;
    private final List<LoadSingleTsFileNode> tsFileNodeList;
    private final List<Integer> failedTsFileNodeIndexes;
    private final PlanFragmentId fragmentId;
    private final Set<TRegionReplicaSet> allReplicaSets;
    private final boolean isGeneratedByPipe;
    private final Map<TTimePartitionSlot, ProgressIndex> timePartitionSlotToProgressIndex;
    private final LoadTsFileDataCacheMemoryBlock block;

    public LoadTsFileScheduler(DistributedQueryPlan distributedQueryPlan, MPPQueryContext queryContext, QueryStateMachine stateMachine, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> internalServiceClientManager, IPartitionFetcher partitionFetcher, boolean isGeneratedByPipe) {
        this.queryContext = queryContext;
        this.stateMachine = stateMachine;
        this.tsFileNodeList = new ArrayList<LoadSingleTsFileNode>();
        this.failedTsFileNodeIndexes = new ArrayList<Integer>();
        this.fragmentId = distributedQueryPlan.getRootSubPlan().getPlanFragment().getId();
        this.dispatcher = new LoadTsFileDispatcherImpl(internalServiceClientManager, isGeneratedByPipe);
        this.partitionFetcher = new DataPartitionBatchFetcher(partitionFetcher);
        this.allReplicaSets = new HashSet<TRegionReplicaSet>();
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.timePartitionSlotToProgressIndex = new HashMap<TTimePartitionSlot, ProgressIndex>();
        this.block = LoadTsFileMemoryManager.getInstance().allocateDataCacheMemoryBlock();
        for (FragmentInstance fragmentInstance : distributedQueryPlan.getInstances()) {
            this.tsFileNodeList.add((LoadSingleTsFileNode)fragmentInstance.getFragment().getPlanNodeTree());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        block45: {
            try {
                this.stateMachine.transitionToRunning();
                int tsFileNodeListSize = this.tsFileNodeList.size();
                boolean isLoadSuccess = true;
                for (int i = 0; i < tsFileNodeListSize; ++i) {
                    LoadSingleTsFileNode node = this.tsFileNodeList.get(i);
                    String filePath = node.getTsFileResource().getTsFilePath();
                    boolean isLoadSingleTsFileSuccess = true;
                    boolean shouldRemoveFileFromLoadingSet = false;
                    try {
                        Set<String> set = LOADING_FILE_SET;
                        synchronized (set) {
                            if (LOADING_FILE_SET.contains(filePath)) {
                                throw new LoadFileException(String.format("TsFile %s is loading by another scheduler.", filePath));
                            }
                            LOADING_FILE_SET.add(filePath);
                        }
                        shouldRemoveFileFromLoadingSet = true;
                        long startTimeMs = System.currentTimeMillis();
                        if (node.isTsFileEmpty()) {
                            LOGGER.info("Load skip TsFile {}, because it has no data.", (Object)filePath);
                        } else {
                            boolean isSecondPhaseSuccess;
                            boolean isFirstPhaseSuccess;
                            if (!node.needDecodeTsFile(slotList -> this.partitionFetcher.queryDataPartition((List<Pair<IDeviceID, TTimePartitionSlot>>)slotList, this.queryContext.getSession().getUserName()))) {
                                long startTime = System.nanoTime();
                                try {
                                    isLoadSingleTsFileSuccess = this.loadLocally(node);
                                }
                                finally {
                                    LOAD_TSFILE_COST_METRICS_SET.recordPhaseTimeCost("load_locally", System.nanoTime() - startTime);
                                }
                            }
                            String uuid = UUID.randomUUID().toString();
                            this.dispatcher.setUuid(uuid);
                            this.allReplicaSets.clear();
                            long startTime = System.nanoTime();
                            try {
                                isFirstPhaseSuccess = this.firstPhase(node);
                            }
                            finally {
                                LOAD_TSFILE_COST_METRICS_SET.recordPhaseTimeCost("first_phase", System.nanoTime() - startTime);
                            }
                            startTime = System.nanoTime();
                            try {
                                isSecondPhaseSuccess = this.secondPhase(isFirstPhaseSuccess, uuid, node.getTsFileResource());
                            }
                            finally {
                                LOAD_TSFILE_COST_METRICS_SET.recordPhaseTimeCost("second_phase", System.nanoTime() - startTime);
                            }
                            if (!isFirstPhaseSuccess || !isSecondPhaseSuccess) {
                                isLoadSingleTsFileSuccess = false;
                            }
                        }
                        if (RegionMigrateService.getInstance().getLastNotifyMigratingTime() > startTimeMs || RegionMigrateService.getInstance().mayHaveMigratingRegions()) {
                            LOGGER.warn("LoadTsFileScheduler: Region migration was detected during loading TsFile {}, will convert to insertion to avoid data loss", (Object)filePath);
                            isLoadSingleTsFileSuccess = false;
                        }
                        if (isLoadSingleTsFileSuccess) {
                            node.clean();
                            LOGGER.info("Load TsFile {} Successfully, load process [{}/{}]", new Object[]{filePath, i + 1, tsFileNodeListSize});
                            continue;
                        }
                        isLoadSuccess = false;
                        this.failedTsFileNodeIndexes.add(i);
                        LOGGER.warn("Can not Load TsFile {}, load process [{}/{}]", new Object[]{filePath, i + 1, tsFileNodeListSize});
                        continue;
                    }
                    catch (Exception e) {
                        isLoadSuccess = false;
                        this.failedTsFileNodeIndexes.add(i);
                        LOGGER.warn("LoadTsFileScheduler loads TsFile {} error", (Object)filePath, (Object)e);
                        continue;
                    }
                    finally {
                        if (shouldRemoveFileFromLoadingSet) {
                            Set<String> set = LOADING_FILE_SET;
                            synchronized (set) {
                                LOADING_FILE_SET.remove(filePath);
                            }
                        }
                    }
                }
                if (isLoadSuccess) {
                    this.stateMachine.transitionToFinished();
                    break block45;
                }
                StringBuilder failedTsFiles = new StringBuilder(!this.tsFileNodeList.isEmpty() ? this.tsFileNodeList.get(0).getTsFileResource().getTsFilePath() : "");
                ListIterator<Integer> iterator = this.failedTsFileNodeIndexes.listIterator(1);
                while (iterator.hasNext()) {
                    failedTsFiles.append(", ").append(this.tsFileNodeList.get(iterator.next()).getTsFileResource().getTsFilePath());
                }
                long startTime = System.nanoTime();
                try {
                    LOGGER.info("Load TsFile(s) failed, will try to convert to tablets and insert. Failed TsFiles: {}", (Object)failedTsFiles);
                    this.convertFailedTsFilesToTabletsAndRetry();
                }
                finally {
                    LOAD_TSFILE_COST_METRICS_SET.recordPhaseTimeCost("scheduler_cast_tablets", System.nanoTime() - startTime);
                }
            }
            finally {
                LoadTsFileMemoryManager.getInstance().releaseDataCacheMemoryBlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean firstPhase(LoadSingleTsFileNode node) {
        TsFileDataManager tsFileDataManager = new TsFileDataManager(this, node, this.block);
        try {
            new TsFileSplitter(node.getTsFileResource().getTsFile(), x$0 -> tsFileDataManager.addOrSendTsFileData(x$0)).splitTsFileByDataPartition();
            if (!tsFileDataManager.sendAllTsFileData()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IllegalStateException e) {
            LOGGER.warn(String.format("Dispatch TsFileData error when parsing TsFile %s.", node.getTsFileResource().getTsFile()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Parse or send TsFile %s error.", node.getTsFileResource().getTsFile()), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            tsFileDataManager.clear();
        }
        return true;
    }

    private boolean dispatchOnePieceNode(LoadTsFilePieceNode pieceNode, TRegionReplicaSet replicaSet) {
        this.allReplicaSets.add(replicaSet);
        FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, pieceNode), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
        instance.setExecutorAndHost((ExecutorType)new StorageExecutor(replicaSet));
        Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatch(null, Collections.singletonList(instance));
        try {
            FragInstanceDispatchResult result = dispatchResultFuture.get(CONFIG.getLoadCleanupTaskExecutionDelayTimeSeconds(), TimeUnit.SECONDS);
            if (!result.isSuccessful()) {
                LOGGER.warn("Dispatch one piece to ReplicaSet {} error. Result status code {}. Result status message {}. Dispatch piece node error:%n{}", new Object[]{replicaSet, TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name(), result.getFailureStatus().getMessage(), pieceNode});
                if (result.getFailureStatus().getSubStatus() != null) {
                    for (TSStatus status : result.getFailureStatus().getSubStatus()) {
                        LOGGER.warn("Sub status code {}. Sub status message {}.", (Object)TSStatusCode.representOf((int)status.getCode()).toString(), (Object)status.getMessage());
                    }
                }
                TSStatus status = result.getFailureStatus();
                status.setMessage(String.format("Load %s piece error in 1st phase. Because ", pieceNode.getTsFile()) + status.getMessage());
                return false;
            }
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.warn("Interrupt or Execution error.", (Throwable)e);
            return false;
        }
        catch (TimeoutException e) {
            dispatchResultFuture.cancel(true);
            LOGGER.warn(String.format("Wait for loading %s time out.", LoadTsFilePieceNode.class.getName()), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean secondPhase(boolean isFirstPhaseSuccess, String uuid, TsFileResource tsFileResource) {
        LOGGER.info("Start dispatching Load command for uuid {}", (Object)uuid);
        File tsFile = tsFileResource.getTsFile();
        TLoadCommandReq loadCommandReq = new TLoadCommandReq((isFirstPhaseSuccess ? LoadCommand.EXECUTE : LoadCommand.ROLLBACK).ordinal(), uuid);
        try {
            loadCommandReq.setIsGeneratedByPipe(this.isGeneratedByPipe);
            loadCommandReq.setTimePartition2ProgressIndex(this.timePartitionSlotToProgressIndex.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
                    ByteBuffer byteBuffer;
                    try (DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                        ((ProgressIndex)entry.getValue()).serialize((OutputStream)dataOutputStream);
                        byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
                    }
                    return byteBuffer;
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Serialize Progress Index error, isFirstPhaseSuccess: %s, uuid: %s, tsFile: %s", isFirstPhaseSuccess, uuid, tsFile.getAbsolutePath()), e);
                }
            })));
            Future<FragInstanceDispatchResult> dispatchResultFuture = this.dispatcher.dispatchCommand(loadCommandReq, this.allReplicaSets);
            FragInstanceDispatchResult result = dispatchResultFuture.get();
            if (!result.isSuccessful()) {
                LOGGER.warn("Dispatch load command {} of TsFile {} error to replicaSets {} error. Result status code {}. Result status message {}.", new Object[]{loadCommandReq, tsFile, this.allReplicaSets, TSStatusCode.representOf((int)result.getFailureStatus().getCode()).name(), result.getFailureStatus().getMessage()});
                TSStatus status = result.getFailureStatus();
                status.setMessage(String.format("Load %s error in second phase. Because %s, first phase is %s", tsFile, status.getMessage(), isFirstPhaseSuccess ? "success" : "failed"));
                return false;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.warn("Interrupt or Execution error.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred during second phase of loading TsFile {}.", (Object)tsFile, (Object)e);
            return false;
        }
        return true;
    }

    private ByteBuffer assignProgressIndex(TsFileResource tsFileResource) throws IOException {
        PipeDataNodeAgent.runtime().assignProgressIndexForTsFileLoad(tsFileResource);
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                tsFileResource.getMaxProgressIndex().serialize((OutputStream)dataOutputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    private boolean loadLocally(LoadSingleTsFileNode node) throws IoTDBException {
        LOGGER.info("Start load TsFile {} locally.", (Object)node.getTsFileResource().getTsFile().getPath());
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new LoadReadOnlyException();
        }
        try {
            FragmentInstance instance = new FragmentInstance(new PlanFragment(this.fragmentId, node), this.fragmentId.genFragmentInstanceId(), null, this.queryContext.getQueryType(), this.queryContext.getTimeOut(), this.queryContext.getSession());
            instance.setExecutorAndHost((ExecutorType)new StorageExecutor(node.getLocalRegionReplicaSet()));
            this.dispatcher.dispatchLocally(instance);
        }
        catch (FragmentInstanceDispatchException e) {
            LOGGER.warn(String.format("Dispatch tsFile %s error to local error. Result status code %s. Result status message %s.", node.getTsFileResource().getTsFile(), TSStatusCode.representOf((int)e.getFailureStatus().getCode()).name(), e.getFailureStatus().getMessage()));
            return false;
        }
        Optional.ofNullable(StorageEngine.getInstance().getDataRegion((DataRegionId)ConsensusGroupId.Factory.createFromTConsensusGroupId((TConsensusGroupId)node.getLocalRegionReplicaSet().getRegionId()))).ifPresent(dataRegion -> dataRegion.getNonSystemDatabaseName().ifPresent(databaseName -> {
            MemTableFlushTask.recordFlushPointsMetricInternal(node.getWritePointCount(), databaseName, dataRegion.getDataRegionIdString());
            MetricService.getInstance().count(node.getWritePointCount(), Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), databaseName, Tag.REGION.toString(), dataRegion.getDataRegionIdString(), Tag.TYPE.toString(), Metric.LOAD_POINT_COUNT.toString()});
            MetricService.getInstance().count(node.getWritePointCount(), Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), databaseName, Tag.REGION.toString(), dataRegion.getDataRegionIdString(), Tag.TYPE.toString(), Metric.LOAD_POINT_COUNT.toString()});
        }));
        return true;
    }

    private void convertFailedTsFilesToTabletsAndRetry() {
        LoadTsFileDataTypeConverter loadTsFileDataTypeConverter = new LoadTsFileDataTypeConverter(this.queryContext, this.isGeneratedByPipe);
        ListIterator<Integer> iterator = this.failedTsFileNodeIndexes.listIterator();
        while (iterator.hasNext()) {
            int failedLoadTsFileIndex = (Integer)iterator.next();
            LoadSingleTsFileNode failedNode = this.tsFileNodeList.get(failedLoadTsFileIndex);
            String filePath = failedNode.getTsFileResource().getTsFilePath();
            try {
                TSStatus status = loadTsFileDataTypeConverter.convertForTreeModel(new LoadTsFileStatement(filePath).setDeleteAfterLoad(failedNode.isDeleteAfterLoad()).setConvertOnTypeMismatch(true)).orElse(null);
                if (loadTsFileDataTypeConverter.isSuccessful(status)) {
                    iterator.remove();
                    LOGGER.info("Load: Successfully converted TsFile {} into tablets and inserted.", (Object)failedNode.getTsFileResource().getTsFilePath());
                    continue;
                }
                LOGGER.warn("Load: Failed to convert to tablets from TsFile {}. Status: {}", (Object)failedNode.getTsFileResource().getTsFilePath(), (Object)status);
            }
            catch (Exception e) {
                LOGGER.warn("Load: Failed to convert to tablets from TsFile {}. Exception: {}", new Object[]{failedNode.getTsFileResource().getTsFilePath(), e.getMessage(), e});
            }
        }
        if (this.failedTsFileNodeIndexes.isEmpty()) {
            LOGGER.info("Load: all failed TsFiles are converted to tablets and inserted.");
            this.stateMachine.transitionToFinished();
        } else {
            String errorMsg = "Load: failed to load some TsFiles by converting them into tablets. Failed TsFiles: " + this.failedTsFileNodeIndexes.stream().map(i -> this.tsFileNodeList.get((int)i).getTsFileResource().getTsFilePath()).collect(Collectors.joining(", "));
            LOGGER.warn(errorMsg);
            this.stateMachine.transitionToFailed((Throwable)((Object)new LoadFileException(errorMsg)));
        }
    }

    @Override
    public void stop(Throwable t) {
    }

    @Override
    public Duration getTotalCpuTime() {
        return null;
    }

    @Override
    public FragmentInfo getFragmentInfo() {
        return null;
    }

    private void computeTimePartitionSlotToProgressIndexIfAbsent(TTimePartitionSlot timePartitionSlot) {
        this.timePartitionSlotToProgressIndex.putIfAbsent(timePartitionSlot, (ProgressIndex)PipeDataNodeAgent.runtime().getNextProgressIndexForTsFileLoad());
    }

    private static class DataPartitionBatchFetcher {
        private final IPartitionFetcher fetcher;

        public DataPartitionBatchFetcher(IPartitionFetcher fetcher) {
            this.fetcher = fetcher;
        }

        public List<TRegionReplicaSet> queryDataPartition(List<Pair<IDeviceID, TTimePartitionSlot>> slotList, String userName) {
            ArrayList<TRegionReplicaSet> replicaSets = new ArrayList<TRegionReplicaSet>();
            int size = slotList.size();
            for (int i = 0; i < size; i += TRANSMIT_LIMIT) {
                List<Pair<IDeviceID, TTimePartitionSlot>> subSlotList = slotList.subList(i, Math.min(size, i + TRANSMIT_LIMIT));
                DataPartition dataPartition = this.fetcher.getOrCreateDataPartition(this.toQueryParam(subSlotList), userName);
                replicaSets.addAll(subSlotList.stream().map(pair -> dataPartition.getDataRegionReplicaSetForWriting(((PlainDeviceID)pair.left).toStringID(), (TTimePartitionSlot)pair.right)).collect(Collectors.toList()));
            }
            return replicaSets;
        }

        private List<DataPartitionQueryParam> toQueryParam(List<Pair<IDeviceID, TTimePartitionSlot>> slots) {
            return slots.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toSet()))).entrySet().stream().map(entry -> new DataPartitionQueryParam(((PlainDeviceID)entry.getKey()).toStringID(), new ArrayList((Collection)entry.getValue()))).collect(Collectors.toList());
        }
    }

    private static class TsFileDataManager {
        private final LoadTsFileScheduler scheduler;
        private final LoadSingleTsFileNode singleTsFileNode;
        private long dataSize;
        private final Map<TConsensusGroupId, Pair<TRegionReplicaSet, LoadTsFilePieceNode>> regionId2ReplicaSetAndNode;
        private final List<ChunkData> nonDirectionalChunkData;
        private final LoadTsFileDataCacheMemoryBlock block;

        public TsFileDataManager(LoadTsFileScheduler scheduler, LoadSingleTsFileNode singleTsFileNode, LoadTsFileDataCacheMemoryBlock block) {
            this.scheduler = scheduler;
            this.singleTsFileNode = singleTsFileNode;
            this.dataSize = 0L;
            this.regionId2ReplicaSetAndNode = new HashMap<TConsensusGroupId, Pair<TRegionReplicaSet, LoadTsFilePieceNode>>();
            this.nonDirectionalChunkData = new ArrayList<ChunkData>();
            this.block = block;
        }

        private boolean addOrSendTsFileData(TsFileData tsFileData) throws LoadFileException {
            return tsFileData.isModification() ? this.addOrSendDeletionData(tsFileData) : this.addOrSendChunkData((ChunkData)tsFileData);
        }

        private boolean isMemoryEnough() {
            return this.dataSize <= SINGLE_SCHEDULER_MAX_MEMORY_SIZE && this.block.hasEnoughMemory();
        }

        private boolean addOrSendChunkData(ChunkData chunkData) throws LoadFileException {
            this.nonDirectionalChunkData.add(chunkData);
            this.dataSize += chunkData.getDataSize();
            this.block.addMemoryUsage(chunkData.getDataSize());
            this.scheduler.computeTimePartitionSlotToProgressIndexIfAbsent(chunkData.getTimePartitionSlot());
            if (!this.isMemoryEnough()) {
                this.routeChunkData();
                List sortedRegionIds = this.regionId2ReplicaSetAndNode.keySet().stream().sorted(Comparator.comparingLong(o -> ((LoadTsFilePieceNode)this.regionId2ReplicaSetAndNode.get(o).getRight()).getDataSize()).reversed()).collect(Collectors.toList());
                for (TConsensusGroupId sortedRegionId : sortedRegionIds) {
                    TRegionReplicaSet replicaSet = (TRegionReplicaSet)this.regionId2ReplicaSetAndNode.get(sortedRegionId).getLeft();
                    LoadTsFilePieceNode pieceNode = (LoadTsFilePieceNode)this.regionId2ReplicaSetAndNode.get(sortedRegionId).getRight();
                    if (pieceNode.getDataSize() == 0L) break;
                    boolean isDispatchSuccess = this.scheduler.dispatchOnePieceNode(pieceNode, replicaSet);
                    this.regionId2ReplicaSetAndNode.replace(sortedRegionId, (Pair<TRegionReplicaSet, LoadTsFilePieceNode>)new Pair((Object)replicaSet, (Object)new LoadTsFilePieceNode(this.singleTsFileNode.getPlanNodeId(), this.singleTsFileNode.getTsFileResource().getTsFile())));
                    this.dataSize -= pieceNode.getDataSize();
                    this.block.reduceMemoryUsage(pieceNode.getDataSize());
                    if (!isDispatchSuccess) {
                        return false;
                    }
                    if (!this.isMemoryEnough()) continue;
                    break;
                }
            }
            return true;
        }

        private void routeChunkData() throws LoadFileException {
            if (this.nonDirectionalChunkData.isEmpty()) {
                return;
            }
            List<TRegionReplicaSet> replicaSets = this.scheduler.partitionFetcher.queryDataPartition(this.nonDirectionalChunkData.stream().map(data -> new Pair((Object)new PlainDeviceID(data.getDevice()), (Object)data.getTimePartitionSlot())).collect(Collectors.toList()), this.scheduler.queryContext.getSession().getUserName());
            for (int i = 0; i < replicaSets.size(); ++i) {
                TRegionReplicaSet replicaSet = replicaSets.get(i);
                TConsensusGroupId regionId = replicaSet.getRegionId();
                if (this.regionId2ReplicaSetAndNode.containsKey(regionId) && !Objects.equals(this.regionId2ReplicaSetAndNode.get(regionId).getLeft(), replicaSet)) {
                    throw new RegionReplicaSetChangedException((TRegionReplicaSet)this.regionId2ReplicaSetAndNode.get(regionId).getLeft(), replicaSet);
                }
                ((LoadTsFilePieceNode)this.regionId2ReplicaSetAndNode.computeIfAbsent(replicaSet.getRegionId(), o -> new Pair((Object)replicaSet, (Object)new LoadTsFilePieceNode(this.singleTsFileNode.getPlanNodeId(), this.singleTsFileNode.getTsFileResource().getTsFile()))).getRight()).addTsFileData(this.nonDirectionalChunkData.get(i));
            }
            this.nonDirectionalChunkData.clear();
        }

        private boolean addOrSendDeletionData(TsFileData deletionData) throws LoadFileException {
            this.routeChunkData();
            for (Map.Entry<TConsensusGroupId, Pair<TRegionReplicaSet, LoadTsFilePieceNode>> entry : this.regionId2ReplicaSetAndNode.entrySet()) {
                this.dataSize += deletionData.getDataSize();
                this.block.addMemoryUsage(deletionData.getDataSize());
                ((LoadTsFilePieceNode)entry.getValue().getRight()).addTsFileData(deletionData);
            }
            return true;
        }

        private boolean sendAllTsFileData() throws LoadFileException {
            this.routeChunkData();
            boolean isAllSuccess = true;
            for (Map.Entry<TConsensusGroupId, Pair<TRegionReplicaSet, LoadTsFilePieceNode>> entry : this.regionId2ReplicaSetAndNode.entrySet()) {
                this.block.reduceMemoryUsage(((LoadTsFilePieceNode)entry.getValue().getRight()).getDataSize());
                if (!isAllSuccess || this.scheduler.dispatchOnePieceNode((LoadTsFilePieceNode)entry.getValue().getRight(), (TRegionReplicaSet)entry.getValue().getLeft())) continue;
                LOGGER.warn("Dispatch piece node {} of TsFile {} error.", entry.getValue(), (Object)this.singleTsFileNode.getTsFileResource().getTsFile());
                isAllSuccess = false;
            }
            return isAllSuccess;
        }

        private void clear() {
            this.regionId2ReplicaSetAndNode.clear();
        }
    }

    public static enum LoadCommand {
        EXECUTE,
        ROLLBACK;

    }
}

