/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.livy.rsc.FutureListener;

public class Utils {
    public static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean condition, String msg, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(msg, args));
        }
    }

    public static void checkState(boolean condition, String msg, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(String.format(msg, args));
        }
    }

    public static void checkNotNull(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    public static RuntimeException propagate(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static ThreadFactory newDaemonThreadFactory(final String nameFormat) {
        return new ThreadFactory(){
            private final AtomicInteger threadId = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(String.format(nameFormat, this.threadId.incrementAndGet()));
                t.setDaemon(true);
                return t;
            }
        };
    }

    public static String join(Iterable<String> strs, String sep) {
        StringBuilder sb = new StringBuilder();
        for (String s : strs) {
            if (s == null || s.isEmpty()) continue;
            sb.append(s).append(sep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - sep.length());
        }
        return sb.toString();
    }

    public static String stackTraceAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static <T> void addListener(Future<T> future, final FutureListener<T> lsnr) {
        future.addListener(new GenericFutureListener<Future<T>>(){

            public void operationComplete(Future<T> f) throws Exception {
                if (f.isSuccess()) {
                    lsnr.onSuccess(f.get());
                } else {
                    lsnr.onFailure(f.cause());
                }
            }
        });
    }

    private Utils() {
    }
}

