/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode.expression;

import com.facebook.presto.bytecode.ArrayOpCode;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.TypeInstruction;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

class NewArrayBytecodeExpression
extends BytecodeExpression {
    private final BytecodeExpression length;
    private final ParameterizedType elementType;
    @Nullable
    private final List<BytecodeExpression> elements;

    NewArrayBytecodeExpression(ParameterizedType type, int length) {
        this(type, BytecodeExpressions.constantInt(length));
    }

    NewArrayBytecodeExpression(ParameterizedType type, BytecodeExpression length) {
        this(type, length, null);
    }

    NewArrayBytecodeExpression(ParameterizedType type, Collection<BytecodeExpression> elements) {
        this(type, BytecodeExpressions.constantInt(elements.size()), elements);
    }

    private NewArrayBytecodeExpression(ParameterizedType type, BytecodeExpression length, Collection<BytecodeExpression> elements) {
        super(type);
        Objects.requireNonNull(type, "type is null");
        BytecodeUtils.checkArgument(type.getArrayComponentType() != null, "type %s must be array type", type);
        this.elementType = type.getArrayComponentType();
        this.length = Objects.requireNonNull(length, "length is null");
        this.elements = elements == null ? null : List.copyOf(elements);
    }

    @Override
    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        BytecodeBlock bytecodeBlock = this.elementType.isPrimitive() ? new BytecodeBlock().append(this.length).append(TypeInstruction.newPrimitiveArray(this.elementType)) : new BytecodeBlock().append(this.length).append(TypeInstruction.newObjectArray(this.elementType));
        if (this.elements != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                BytecodeExpression element = this.elements.get(i);
                bytecodeBlock.dup().append(BytecodeExpressions.constantInt(i)).append(element).append(ArrayOpCode.getArrayOpCode(this.elementType).getStore());
            }
        }
        return bytecodeBlock;
    }

    @Override
    protected String formatOneLine() {
        if (this.elements == null) {
            return "new " + this.elementType.getSimpleName() + "[" + this.length + "]";
        }
        return "new " + this.elementType.getSimpleName() + "[] {" + this.elements.stream().map(BytecodeExpression::toString).collect(Collectors.joining(", ")) + "}";
    }

    @Override
    public List<BytecodeNode> getChildNodes() {
        return List.of();
    }
}

