/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.orc;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.SourceReaderOptions;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.connector.file.src.util.Pool;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcFilters;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.util.SerializableHadoopConfigWrapper;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.vector.OrcVectorizedBatchWrapper;
import org.apache.flink.table.store.shaded.org.apache.orc.RecordReader;
import org.apache.flink.table.store.shaded.org.apache.orc.TypeDescription;
import org.apache.flink.util.Preconditions;

public abstract class AbstractOrcFileInputFormat<T, BatchT, SplitT extends FileSourceSplit>
implements BulkFormat<T, SplitT> {
    private static final long serialVersionUID = 1L;
    protected final OrcShim<BatchT> shim;
    protected final SerializableHadoopConfigWrapper hadoopConfigWrapper;
    protected final TypeDescription schema;
    protected final int[] selectedFields;
    protected final List<OrcFilters.Predicate> conjunctPredicates;
    protected final int batchSize;

    protected AbstractOrcFileInputFormat(OrcShim<BatchT> shim, org.apache.hadoop.conf.Configuration hadoopConfig, TypeDescription schema, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, int batchSize) {
        this.shim = shim;
        this.hadoopConfigWrapper = new SerializableHadoopConfigWrapper(Preconditions.checkNotNull(hadoopConfig));
        this.schema = Preconditions.checkNotNull(schema);
        this.selectedFields = Preconditions.checkNotNull(selectedFields);
        this.conjunctPredicates = Preconditions.checkNotNull(conjunctPredicates);
        this.batchSize = batchSize;
    }

    public OrcVectorizedReader<T, BatchT> createReader(Configuration config, SplitT split) throws IOException {
        int numBatchesToCirculate = config.getInteger(SourceReaderOptions.ELEMENT_QUEUE_CAPACITY);
        Pool<OrcReaderBatch<T, BatchT>> poolOfBatches = this.createPoolOfBatches(split, numBatchesToCirculate);
        RecordReader orcReader = this.shim.createRecordReader(this.hadoopConfigWrapper.getHadoopConfig(), this.schema, this.selectedFields, this.conjunctPredicates, ((FileSourceSplit)split).path(), ((FileSourceSplit)split).offset(), ((FileSourceSplit)split).length());
        return new OrcVectorizedReader<T, BatchT>(this.shim, orcReader, poolOfBatches);
    }

    public OrcVectorizedReader<T, BatchT> restoreReader(Configuration config, SplitT split) throws IOException {
        assert (((FileSourceSplit)split).getReaderPosition().isPresent());
        BulkFormat.Reader reader = this.createReader(config, (FileSourceSplit)split);
        ((OrcVectorizedReader)reader).seek(((FileSourceSplit)split).getReaderPosition().get());
        return reader;
    }

    @Override
    public boolean isSplittable() {
        return true;
    }

    public abstract OrcReaderBatch<T, BatchT> createReaderBatch(SplitT var1, OrcVectorizedBatchWrapper<BatchT> var2, Pool.Recycler<OrcReaderBatch<T, BatchT>> var3, int var4);

    @Override
    public abstract TypeInformation<T> getProducedType();

    private Pool<OrcReaderBatch<T, BatchT>> createPoolOfBatches(SplitT split, int numBatches) {
        Pool<OrcReaderBatch<OrcReaderBatch<T, BatchT>, BatchT>> pool = new Pool<OrcReaderBatch<OrcReaderBatch<T, BatchT>, BatchT>>(numBatches);
        for (int i = 0; i < numBatches; ++i) {
            OrcVectorizedBatchWrapper<BatchT> orcBatch = this.shim.createBatchWrapper(this.schema, this.batchSize);
            OrcReaderBatch<T, BatchT> batch = this.createReaderBatch(split, orcBatch, pool.recycler(), this.batchSize);
            pool.add(batch);
        }
        return pool;
    }

    protected static final class OrcVectorizedReader<T, BatchT>
    implements BulkFormat.Reader<T> {
        private final OrcShim<BatchT> shim;
        private final RecordReader orcReader;
        private final Pool<OrcReaderBatch<T, BatchT>> pool;
        private long recordsToSkip;

        protected OrcVectorizedReader(OrcShim<BatchT> shim, RecordReader orcReader, Pool<OrcReaderBatch<T, BatchT>> pool) {
            this.shim = Preconditions.checkNotNull(shim, "orc shim");
            this.orcReader = Preconditions.checkNotNull(orcReader, "orcReader");
            this.pool = Preconditions.checkNotNull(pool, "pool");
        }

        @Override
        @Nullable
        public BulkFormat.RecordIterator<T> readBatch() throws IOException {
            OrcReaderBatch<T, BatchT> batch = this.getCachedEntry();
            OrcVectorizedBatchWrapper<BatchT> orcVectorBatch = batch.orcVectorizedRowBatch();
            long orcRowNumber = this.orcReader.getRowNumber();
            if (!this.shim.nextBatch(this.orcReader, orcVectorBatch.getBatch())) {
                batch.recycle();
                return null;
            }
            BulkFormat.RecordIterator<T> records = batch.convertAndGetIterator(orcVectorBatch, orcRowNumber);
            if (this.recordsToSkip > 0L) {
                this.skipRecord(records);
            }
            return records;
        }

        @Override
        public void close() throws IOException {
            this.orcReader.close();
        }

        public void seek(CheckpointedPosition position) throws IOException {
            this.orcReader.seekToRow(position.getOffset());
            this.recordsToSkip = position.getRecordsAfterOffset();
        }

        private OrcReaderBatch<T, BatchT> getCachedEntry() throws IOException {
            try {
                return this.pool.pollEntry();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted");
            }
        }

        private void skipRecord(BulkFormat.RecordIterator<T> records) {
            while (this.recordsToSkip > 0L && records.next() != null) {
                --this.recordsToSkip;
            }
        }
    }

    protected static abstract class OrcReaderBatch<T, BatchT> {
        private final OrcVectorizedBatchWrapper<BatchT> orcVectorizedRowBatch;
        private final Pool.Recycler<OrcReaderBatch<T, BatchT>> recycler;

        protected OrcReaderBatch(OrcVectorizedBatchWrapper<BatchT> orcVectorizedRowBatch, Pool.Recycler<OrcReaderBatch<T, BatchT>> recycler) {
            this.orcVectorizedRowBatch = Preconditions.checkNotNull(orcVectorizedRowBatch);
            this.recycler = Preconditions.checkNotNull(recycler);
        }

        public void recycle() {
            this.recycler.recycle(this);
        }

        public OrcVectorizedBatchWrapper<BatchT> orcVectorizedRowBatch() {
            return this.orcVectorizedRowBatch;
        }

        public abstract BulkFormat.RecordIterator<T> convertAndGetIterator(OrcVectorizedBatchWrapper<BatchT> var1, long var2) throws IOException;
    }
}

