/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;

public class MemCheckpointStreamFactory
implements CheckpointStreamFactory {
    private final int maxStateSize;

    public MemCheckpointStreamFactory(int maxStateSize) {
        this.maxStateSize = maxStateSize;
    }

    @Override
    public CheckpointStateOutputStream createCheckpointStateOutputStream(CheckpointedStateScope scope) throws IOException {
        return new MemoryCheckpointOutputStream(this.maxStateSize);
    }

    @Override
    public boolean canFastDuplicate(StreamStateHandle stateHandle, CheckpointedStateScope scope) {
        return false;
    }

    @Override
    public List<StreamStateHandle> duplicate(List<StreamStateHandle> stateHandles, CheckpointedStateScope scope) throws IOException {
        throw new UnsupportedOperationException("We can not duplicate handles in memory.");
    }

    public String toString() {
        return "In-Memory Stream Factory";
    }

    static void checkSize(int size, int maxSize) throws IOException {
        if (size > maxSize) {
            throw new IOException(String.format("Size of the state is larger than the maximum permitted memory-backed state. Size=%d, maxSize=%d. Consider using a different checkpoint storage, like the %s.", size, maxSize, FileSystemCheckpointStorage.class.getSimpleName()));
        }
    }

    public static class MemoryCheckpointOutputStream
    extends CheckpointStateOutputStream {
        private final ByteArrayOutputStreamWithPos os = new ByteArrayOutputStreamWithPos();
        private final int maxSize;
        private AtomicBoolean closed;
        boolean isEmpty = true;

        public MemoryCheckpointOutputStream(int maxSize) {
            this.maxSize = maxSize;
            this.closed = new AtomicBoolean(false);
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
            this.isEmpty = false;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
            this.isEmpty = false;
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void sync() throws IOException {
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                this.closeInternal();
            }
        }

        @Override
        @Nullable
        public StreamStateHandle closeAndGetHandle() throws IOException {
            if (this.isEmpty) {
                return null;
            }
            return new ByteStreamStateHandle(String.valueOf(UUID.randomUUID()), this.closeAndGetBytes());
        }

        @Override
        public long getPos() throws IOException {
            return this.os.getPosition();
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        public byte[] closeAndGetBytes() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                MemCheckpointStreamFactory.checkSize(this.os.size(), this.maxSize);
                byte[] bytes = this.os.toByteArray();
                this.closeInternal();
                return bytes;
            }
            throw new IOException("stream has already been closed");
        }

        private void closeInternal() {
            this.os.reset();
        }
    }
}

