/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.strategies.StrategyUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
class DecimalPlusTypeStrategy
implements TypeStrategy {
    DecimalPlusTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType addend1 = argumentDataTypes.get(0).getLogicalType();
        LogicalType addend2 = argumentDataTypes.get(1).getLogicalType();
        if (addend1 instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(0));
        }
        if (addend2 instanceof LegacyTypeInformationType) {
            return Optional.of(argumentDataTypes.get(1));
        }
        if (!StrategyUtils.isDecimalComputation(addend1, addend2)) {
            return Optional.empty();
        }
        DecimalType decimalType = LogicalTypeMerging.findAdditionDecimalType(LogicalTypeChecks.getPrecision(addend1), LogicalTypeChecks.getScale(addend1), LogicalTypeChecks.getPrecision(addend2), LogicalTypeChecks.getScale(addend2));
        return Optional.of(TypeConversions.fromLogicalToDataType(decimalType));
    }
}

