/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class LookupCallExpression
implements Expression {
    private final String unresolvedName;
    private final List<Expression> args;

    LookupCallExpression(String unresolvedFunction, List<Expression> args) {
        this.unresolvedName = Preconditions.checkNotNull(unresolvedFunction);
        this.args = Collections.unmodifiableList(Preconditions.checkNotNull(args));
    }

    public String getUnresolvedName() {
        return this.unresolvedName;
    }

    @Override
    public String asSummaryString() {
        List argList = this.args.stream().map(Object::toString).collect(Collectors.toList());
        return this.unresolvedName + "(" + String.join((CharSequence)", ", argList) + ")";
    }

    @Override
    public List<Expression> getChildren() {
        return this.args;
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupCallExpression that = (LookupCallExpression)o;
        return Objects.equals(this.unresolvedName, that.unresolvedName) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.unresolvedName, this.args);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

