/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.scheduler.DeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersion;
import org.apache.flink.runtime.scheduler.SlotExecutionVertexAssignment;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

class DeploymentHandle {
    private final ExecutionVertexVersion requiredVertexVersion;
    private final ExecutionVertexDeploymentOption executionVertexDeploymentOption;
    private final SlotExecutionVertexAssignment slotExecutionVertexAssignment;

    public DeploymentHandle(ExecutionVertexVersion requiredVertexVersion, ExecutionVertexDeploymentOption executionVertexDeploymentOption, SlotExecutionVertexAssignment slotExecutionVertexAssignment) {
        this.requiredVertexVersion = Preconditions.checkNotNull(requiredVertexVersion);
        this.executionVertexDeploymentOption = Preconditions.checkNotNull(executionVertexDeploymentOption);
        this.slotExecutionVertexAssignment = Preconditions.checkNotNull(slotExecutionVertexAssignment);
    }

    public ExecutionVertexID getExecutionVertexId() {
        return this.requiredVertexVersion.getExecutionVertexId();
    }

    public ExecutionVertexVersion getRequiredVertexVersion() {
        return this.requiredVertexVersion;
    }

    public DeploymentOption getDeploymentOption() {
        return this.executionVertexDeploymentOption.getDeploymentOption();
    }

    public SlotExecutionVertexAssignment getSlotExecutionVertexAssignment() {
        return this.slotExecutionVertexAssignment;
    }

    public Optional<LogicalSlot> getLogicalSlot() {
        CompletableFuture<LogicalSlot> logicalSlotFuture = this.slotExecutionVertexAssignment.getLogicalSlotFuture();
        Preconditions.checkState(logicalSlotFuture.isDone(), "method can only be called after slot future is done");
        if (logicalSlotFuture.isCompletedExceptionally()) {
            return Optional.empty();
        }
        return Optional.ofNullable(logicalSlotFuture.getNow(null));
    }
}

