/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.convergence;

import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.types.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorksetEmptyConvergenceCriterion
implements ConvergenceCriterion<LongValue> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WorksetEmptyConvergenceCriterion.class);
    public static final String AGGREGATOR_NAME = "pact.runtime.workset-empty-aggregator";

    @Override
    public boolean isConverged(int iteration, LongValue value) {
        long updatedElements = value.getValue();
        if (log.isInfoEnabled()) {
            log.info("[" + updatedElements + "] elements updated in the solutionset in iteration [" + iteration + "]");
        }
        return updatedElements == 0L;
    }
}

