/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.util.Preconditions;

public class BufferCompressor {
    private final BlockCompressor blockCompressor;
    private final NetworkBuffer internalBuffer;

    public BufferCompressor(int bufferSize, String factoryName) {
        Preconditions.checkArgument(bufferSize > 0);
        Preconditions.checkNotNull(factoryName);
        byte[] heapBuffer = new byte[2 * bufferSize];
        this.internalBuffer = new NetworkBuffer(MemorySegmentFactory.wrap(heapBuffer), FreeingBufferRecycler.INSTANCE);
        this.blockCompressor = BlockCompressionFactory.createBlockCompressionFactory(factoryName).getCompressor();
    }

    public Buffer compressToIntermediateBuffer(Buffer buffer) {
        int compressedLen = this.compress(buffer);
        if (compressedLen == 0) {
            return buffer;
        }
        this.internalBuffer.setCompressed(true);
        this.internalBuffer.setSize(compressedLen);
        return this.internalBuffer.retainBuffer();
    }

    public Buffer compressToOriginalBuffer(Buffer buffer) {
        int compressedLen = this.compress(buffer);
        if (compressedLen == 0) {
            return buffer;
        }
        int memorySegmentOffset = buffer.getMemorySegmentOffset();
        MemorySegment segment = buffer.getMemorySegment();
        segment.put(memorySegmentOffset, this.internalBuffer.array(), 0, compressedLen);
        return new ReadOnlySlicedNetworkBuffer(buffer.asByteBuf(), 0, compressedLen, memorySegmentOffset, true);
    }

    private int compress(Buffer buffer) {
        Preconditions.checkArgument(buffer != null, "The input buffer must not be null.");
        Preconditions.checkArgument(buffer.isBuffer(), "Event can not be compressed.");
        Preconditions.checkArgument(!buffer.isCompressed(), "Buffer already compressed.");
        Preconditions.checkArgument(buffer.getReaderIndex() == 0, "Reader index of the input buffer must be 0.");
        Preconditions.checkArgument(buffer.readableBytes() > 0, "No data to be compressed.");
        Preconditions.checkState(this.internalBuffer.refCnt() == 1, "Illegal reference count, buffer need to be released.");
        try {
            int length = buffer.getSize();
            int compressedLen = this.blockCompressor.compress(buffer.getNioBuffer(0, length), 0, length, this.internalBuffer.getNioBuffer(0, this.internalBuffer.capacity()), 0);
            return compressedLen < length ? compressedLen : 0;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }
}

