/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.util.Preconditions;

@Internal
public class FileSinkCommittable
implements Serializable {
    private final String bucketId;
    @Nullable
    private final InProgressFileWriter.PendingFileRecoverable pendingFile;
    @Nullable
    private final InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup;
    @Nullable
    private final Path compactedFileToCleanup;

    public FileSinkCommittable(String bucketId, InProgressFileWriter.PendingFileRecoverable pendingFile) {
        this.bucketId = bucketId;
        this.pendingFile = Preconditions.checkNotNull(pendingFile);
        this.inProgressFileToCleanup = null;
        this.compactedFileToCleanup = null;
    }

    public FileSinkCommittable(String bucketId, InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup) {
        this.bucketId = bucketId;
        this.pendingFile = null;
        this.inProgressFileToCleanup = Preconditions.checkNotNull(inProgressFileToCleanup);
        this.compactedFileToCleanup = null;
    }

    public FileSinkCommittable(String bucketId, Path compactedFileToCleanup) {
        this.bucketId = bucketId;
        this.pendingFile = null;
        this.inProgressFileToCleanup = null;
        this.compactedFileToCleanup = Preconditions.checkNotNull(compactedFileToCleanup);
    }

    FileSinkCommittable(String bucketId, @Nullable InProgressFileWriter.PendingFileRecoverable pendingFile, @Nullable InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup, @Nullable Path compactedFileToCleanup) {
        this.bucketId = bucketId;
        this.pendingFile = pendingFile;
        this.inProgressFileToCleanup = inProgressFileToCleanup;
        this.compactedFileToCleanup = compactedFileToCleanup;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public boolean hasPendingFile() {
        return this.pendingFile != null;
    }

    @Nullable
    public InProgressFileWriter.PendingFileRecoverable getPendingFile() {
        return this.pendingFile;
    }

    public boolean hasInProgressFileToCleanup() {
        return this.inProgressFileToCleanup != null;
    }

    @Nullable
    public InProgressFileWriter.InProgressFileRecoverable getInProgressFileToCleanup() {
        return this.inProgressFileToCleanup;
    }

    public boolean hasCompactedFileToCleanup() {
        return this.compactedFileToCleanup != null;
    }

    @Nullable
    public Path getCompactedFileToCleanup() {
        return this.compactedFileToCleanup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSinkCommittable that = (FileSinkCommittable)o;
        return Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.pendingFile, that.pendingFile) && Objects.equals(this.inProgressFileToCleanup, that.inProgressFileToCleanup) && Objects.equals(this.compactedFileToCleanup, that.compactedFileToCleanup);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.pendingFile, this.inProgressFileToCleanup, this.compactedFileToCleanup);
    }

    public String toString() {
        return "FileSinkCommittable{bucketId='" + this.bucketId + ", pendingFile=" + this.pendingFile + ", inProgressFileToCleanup=" + this.inProgressFileToCleanup + ", compactedFileToCleanup=" + this.compactedFileToCleanup + '}';
    }
}

