/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.data.DataFileReader;
import org.apache.flink.table.store.file.mergetree.MergeTreeReader;
import org.apache.flink.table.store.file.mergetree.compact.ConcatRecordReader;
import org.apache.flink.table.store.file.mergetree.compact.IntervalPartition;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;
import org.apache.flink.table.store.file.operation.FileStoreRead;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.ProjectKeyRecordReader;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.types.logical.RowType;

public class KeyValueFileStoreRead
implements FileStoreRead<KeyValue> {
    private final DataFileReader.Factory dataFileReaderFactory;
    private final Comparator<RowData> keyComparator;
    private final MergeFunction mergeFunction;
    private int[][] keyProjectedFields;
    private List<Predicate> filters;

    public KeyValueFileStoreRead(SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, Comparator<RowData> keyComparator, MergeFunction mergeFunction, FileFormat fileFormat, FileStorePathFactory pathFactory) {
        this.dataFileReaderFactory = new DataFileReader.Factory(schemaManager, schemaId, keyType, valueType, fileFormat, pathFactory);
        this.keyComparator = keyComparator;
        this.mergeFunction = mergeFunction;
    }

    public KeyValueFileStoreRead withKeyProjection(int[][] projectedFields) {
        this.dataFileReaderFactory.withKeyProjection(projectedFields);
        this.keyProjectedFields = projectedFields;
        return this;
    }

    public KeyValueFileStoreRead withValueProjection(int[][] projectedFields) {
        this.dataFileReaderFactory.withValueProjection(projectedFields);
        return this;
    }

    @Override
    public FileStoreRead<KeyValue> withFilter(Predicate predicate) {
        this.filters = PredicateBuilder.splitAnd(predicate);
        return this;
    }

    @Override
    public RecordReader<KeyValue> createReader(Split split) throws IOException {
        if (split.isIncremental()) {
            DataFileReader dataFileReader = this.dataFileReaderFactory.create(split.partition(), split.bucket(), true, this.filters);
            ArrayList suppliers = new ArrayList();
            for (DataFileMeta file : split.files()) {
                suppliers.add(() -> dataFileReader.read(this.changelogFile(file).orElse(file.fileName())));
            }
            return ConcatRecordReader.create(suppliers);
        }
        DataFileReader dataFileReader = this.dataFileReaderFactory.create(split.partition(), split.bucket(), false, this.filters);
        MergeTreeReader reader = new MergeTreeReader(new IntervalPartition(split.files(), this.keyComparator).partition(), true, dataFileReader, this.keyComparator, this.mergeFunction.copy());
        return this.keyProjectedFields == null ? reader : new ProjectKeyRecordReader(reader, this.keyProjectedFields);
    }

    private Optional<String> changelogFile(DataFileMeta fileMeta) {
        for (String file : fileMeta.extraFiles()) {
            if (!file.startsWith("changelog-")) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }
}

