/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.minlog.Log;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

@Internal
class MinlogForwarder
extends Log.Logger {
    private final Logger log;

    MinlogForwarder(Logger log) {
        this.log = Preconditions.checkNotNull(log);
    }

    public void log(int level, String category, String message, Throwable ex) {
        String logString = "[KRYO " + category + "] " + message;
        switch (level) {
            case 5: {
                this.log.error(logString, ex);
                break;
            }
            case 4: {
                this.log.warn(logString, ex);
                break;
            }
            case 3: {
                this.log.info(logString, ex);
                break;
            }
            case 2: {
                this.log.debug(logString, ex);
                break;
            }
            case 1: {
                this.log.trace(logString, ex);
            }
        }
    }
}

