/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.bridge;

import java.util.Arrays;
import javax.management.ObjectName;
import org.apache.activemq.artemis.jms.bridge.ActiveMQJMSBridgeLogger;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.slf4j.Logger;

public class ActiveMQJMSBridgeLogger_impl
implements ActiveMQJMSBridgeLogger {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQJMSBridgeLogger_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void failedToSetUpBridge(String bridgeName, long failureRetryInterval) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ341000: Failed to set up JMS bridge {}} connections. Most probably the source or target servers are unavailable. Will retry after a pause of {} ms", (Object)bridgeName, (Object)failureRetryInterval);
        }
    }

    @Override
    public void bridgeReconnected(String bridgeName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ341001: JMS Bridge {} succeeded in reconnecting to servers", (Object)bridgeName);
        }
    }

    @Override
    public void bridgeConnected(String bridgeName) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AMQ341002: JMSBridge {} succeeded in connecting to servers", (Object)bridgeName);
        }
    }

    @Override
    public void errorBridgeAlreadyStarted(String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342000: Attempt to start JMS Bridge {}, but is already started", (Object)bridgeName);
        }
    }

    @Override
    public void errorStartingBridge(String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342001: Failed to start JMS Bridge {}", (Object)bridgeName);
        }
    }

    @Override
    public void errorUnregisteringBridge(ObjectName objectName, String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342002: Failed to unregisted JMS Bridge {} - {}", (Object)objectName, (Object)bridgeName);
        }
    }

    @Override
    public void errorConnectingBridge(String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342003: JMS Bridge {} unable to set up connections, bridge will be stopped", (Object)bridgeName);
        }
    }

    @Override
    public void bridgeRetry(String bridgeName, long failureRetryInterval) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342004: JMS Bridge {}, will retry after a pause of {} ms", (Object)bridgeName, (Object)failureRetryInterval);
        }
    }

    @Override
    public void bridgeNotStarted(String bridgeName) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342005: JMS Bridge {} unable to set up connections, bridge will not be started", (Object)bridgeName);
        }
    }

    @Override
    public void bridgeFailure(String bridgeName, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342006: JMS Bridge {}, detected failure on bridge connection", (Object)bridgeName, (Object)e);
        }
    }

    @Override
    public void bridgeAckError(String bridgeName, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342009: JMS Bridge {} failed to send + acknowledge batch, closing JMS objects", (Object)bridgeName, (Object)e);
        }
    }

    @Override
    public void bridgeConnectError(String bridgeName, Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342010: Failed to connect JMS Bridge {}", (Object)bridgeName, (Object)e);
        }
    }

    @Override
    public void transactionRolledBack(Exception e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("AMQ342011: Transaction rolled back, retrying TX", (Throwable)e);
        }
    }

    @Override
    public void jmsBridgeSrcConnectError(String bridgeName, Exception e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ344001: JMS Bridge {}, failed to start source connection", (Object)bridgeName, (Object)e);
        }
    }

    @Override
    public void jmsBridgeTransactionManagerMissing(String bridgeName, QualityOfServiceMode qosMode) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("AMQ344002: Failed to start JMS Bridge {}.  QoS Mode: {} requires a Transaction Manager, none found", (Object)bridgeName, (Object)qosMode);
        }
    }
}

