/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;

public class MultiKeyTest {
    Integer ONE = 1;
    Integer TWO = 2;
    Integer THREE = 3;
    Integer FOUR = 4;
    Integer FIVE = 5;

    @Test
    public void testConstructors() throws Exception {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        Assertions.assertArrayEquals((Object[])new Object[]{this.ONE, this.TWO}, (Object[])mk.getKeys());
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE);
        Assertions.assertArrayEquals((Object[])new Object[]{this.ONE, this.TWO, this.THREE}, (Object[])mk.getKeys());
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR);
        Assertions.assertArrayEquals((Object[])new Object[]{this.ONE, this.TWO, this.THREE, this.FOUR}, (Object[])mk.getKeys());
        mk = new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR, (Object)this.FIVE);
        Assertions.assertArrayEquals((Object[])new Object[]{this.ONE, this.TWO, this.THREE, this.FOUR, this.FIVE}, (Object[])mk.getKeys());
        mk = new MultiKey((Object[])new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO}, false);
        Assertions.assertArrayEquals((Object[])new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, (Object[])mk.getKeys());
    }

    @Test
    public void testConstructorsByArray() throws Exception {
        Object[] keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys);
        Assertions.assertArrayEquals((Object[])new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, (Object[])mk.getKeys());
        keys[3] = this.FIVE;
        Assertions.assertArrayEquals((Object[])new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, (Object[])mk.getKeys());
        keys = new Integer[]{};
        mk = new MultiKey(keys);
        Assertions.assertArrayEquals((Object[])new Object[0], (Object[])mk.getKeys());
        keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        mk = new MultiKey(keys, true);
        Assertions.assertArrayEquals((Object[])new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, (Object[])mk.getKeys());
        keys[3] = this.FIVE;
        Assertions.assertArrayEquals((Object[])new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, (Object[])mk.getKeys());
        keys = new Integer[]{this.THREE, this.FOUR, this.ONE, this.TWO};
        mk = new MultiKey(keys, false);
        Assertions.assertArrayEquals((Object[])new Object[]{this.THREE, this.FOUR, this.ONE, this.TWO}, (Object[])mk.getKeys());
        keys[3] = this.FIVE;
        Assertions.assertArrayEquals((Object[])new Object[]{this.THREE, this.FOUR, this.ONE, this.FIVE}, (Object[])mk.getKeys());
    }

    @TestFactory
    public Collection<DynamicTest> testConstructorsByArrayNull() {
        Integer[] keys = null;
        return Arrays.asList(DynamicTest.dynamicTest((String)"Integer[] null", () -> Assertions.assertThrows(NullPointerException.class, () -> new MultiKey((Object[])keys))), DynamicTest.dynamicTest((String)"Integer[] null + makeClone true", () -> Assertions.assertThrows(NullPointerException.class, () -> new MultiKey((Object[])keys, true))), DynamicTest.dynamicTest((String)"Integer[] null + makeClone false", () -> Assertions.assertThrows(NullPointerException.class, () -> new MultiKey((Object[])keys, false))));
    }

    @Test
    public void testEquals() {
        MultiKey mk1 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk3 = new MultiKey((Object)this.ONE, (Object)"TWO");
        Assertions.assertEquals((Object)mk1, (Object)mk1);
        Assertions.assertEquals((Object)mk1, (Object)mk2);
        Assertions.assertNotEquals((Object)mk1, (Object)mk3);
        Assertions.assertNotEquals((Object)"", (Object)mk1);
        Assertions.assertNotEquals(null, (Object)mk1);
    }

    @Test
    public void testEqualsAfterSerialization() throws IOException, ClassNotFoundException {
        SystemHashCodeSimulatingKey sysKey = new SystemHashCodeSimulatingKey("test");
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)sysKey);
        HashMap<MultiKey, Integer> map = new HashMap<MultiKey, Integer>();
        map.put(mk, this.TWO);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(sysKey);
        out.writeObject(map);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        sysKey = (SystemHashCodeSimulatingKey)in.readObject();
        Map map2 = (Map)in.readObject();
        in.close();
        Assertions.assertEquals((int)2, (int)sysKey.hashCode());
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)sysKey);
        Assertions.assertEquals((Object)this.TWO, map2.get(mk2));
    }

    @Test
    public void testEqualsAfterSerializationOfDerivedClass() throws IOException, ClassNotFoundException {
        DerivedMultiKey<String> mk = new DerivedMultiKey<String>("A", "B");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(mk);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        DerivedMultiKey mk2 = (DerivedMultiKey)((Object)in.readObject());
        in.close();
        Assertions.assertEquals((int)mk.hashCode(), (int)mk2.hashCode());
    }

    @TestFactory
    public Collection<DynamicTest> testGetIndexed() {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        return Arrays.asList(DynamicTest.dynamicTest((String)"0", () -> Assertions.assertSame((Object)this.ONE, (Object)mk.getKey(0))), DynamicTest.dynamicTest((String)"1", () -> Assertions.assertSame((Object)this.TWO, (Object)mk.getKey(1))), DynamicTest.dynamicTest((String)"-1", () -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> mk.getKey(-1))), DynamicTest.dynamicTest((String)"2", () -> Assertions.assertThrows(IndexOutOfBoundsException.class, () -> mk.getKey(2))));
    }

    @Test
    public void testGetKeysArrayConstructorCloned() {
        Object[] keys = new Integer[]{this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys, true);
        Object[] array = mk.getKeys();
        Assertions.assertNotSame((Object)array, (Object)keys);
        Assertions.assertArrayEquals((Object[])array, (Object[])keys);
        Assertions.assertSame((Object)this.ONE, (Object)array[0]);
        Assertions.assertSame((Object)this.TWO, (Object)array[1]);
        Assertions.assertEquals((int)2, (int)array.length);
    }

    @Test
    public void testGetKeysArrayConstructorNonCloned() {
        Object[] keys = new Integer[]{this.ONE, this.TWO};
        MultiKey mk = new MultiKey(keys, false);
        Object[] array = mk.getKeys();
        Assertions.assertNotSame((Object)array, (Object)keys);
        Assertions.assertArrayEquals((Object[])array, (Object[])keys);
        Assertions.assertSame((Object)this.ONE, (Object)array[0]);
        Assertions.assertSame((Object)this.TWO, (Object)array[1]);
        Assertions.assertEquals((int)2, (int)array.length);
    }

    @Test
    public void testGetKeysSimpleConstructor() {
        MultiKey mk = new MultiKey((Object)this.ONE, (Object)this.TWO);
        Object[] array = mk.getKeys();
        Assertions.assertSame((Object)this.ONE, (Object)array[0]);
        Assertions.assertSame((Object)this.TWO, (Object)array[1]);
        Assertions.assertEquals((int)2, (int)array.length);
    }

    @Test
    public void testHashCode() {
        MultiKey mk1 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk2 = new MultiKey((Object)this.ONE, (Object)this.TWO);
        MultiKey mk3 = new MultiKey((Object)this.ONE, (Object)"TWO");
        Assertions.assertEquals((int)mk1.hashCode(), (int)mk1.hashCode());
        Assertions.assertEquals((int)mk1.hashCode(), (int)mk2.hashCode());
        Assertions.assertTrue((mk1.hashCode() != mk3.hashCode() ? 1 : 0) != 0);
        int total = 0 ^ this.ONE.hashCode() ^ this.TWO.hashCode();
        Assertions.assertEquals((int)total, (int)mk1.hashCode());
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)2, (int)new MultiKey((Object)this.ONE, (Object)this.TWO).size());
        Assertions.assertEquals((int)2, (int)new MultiKey(null, null).size());
        Assertions.assertEquals((int)3, (int)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE).size());
        Assertions.assertEquals((int)3, (int)new MultiKey(null, null, null).size());
        Assertions.assertEquals((int)4, (int)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR).size());
        Assertions.assertEquals((int)4, (int)new MultiKey(null, null, null, null).size());
        Assertions.assertEquals((int)5, (int)new MultiKey((Object)this.ONE, (Object)this.TWO, (Object)this.THREE, (Object)this.FOUR, (Object)this.FIVE).size());
        Assertions.assertEquals((int)5, (int)new MultiKey(null, null, null, null, null).size());
        Assertions.assertEquals((int)0, (int)new MultiKey(new Object[0]).size());
        Assertions.assertEquals((int)1, (int)new MultiKey((Object[])new Integer[]{this.ONE}).size());
        Assertions.assertEquals((int)2, (int)new MultiKey((Object[])new Integer[]{this.ONE, this.TWO}).size());
        Assertions.assertEquals((int)7, (int)new MultiKey((Object[])new Integer[]{this.ONE, this.TWO, this.ONE, this.TWO, this.ONE, this.TWO, this.ONE}).size());
    }

    @Test
    public void testTwoArgCtor() {
        MultiKeyTest key1 = new MultiKeyTest();
        MultiKeyTest key2 = new MultiKeyTest();
        MultiKeyTest[] keys = (MultiKeyTest[])new MultiKey((Object)key1, (Object)key2).getKeys();
        Assertions.assertNotNull((Object)keys);
    }

    static class SystemHashCodeSimulatingKey
    implements Serializable {
        private static final long serialVersionUID = -1736147315703444603L;
        private final String name;
        private int hashCode = 1;

        SystemHashCodeSimulatingKey(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            return obj instanceof SystemHashCodeSimulatingKey && this.name.equals(((SystemHashCodeSimulatingKey)obj).name);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private Object readResolve() {
            this.hashCode = 2;
            return this;
        }
    }

    static class DerivedMultiKey<T>
    extends MultiKey<T> {
        private static final long serialVersionUID = 1928896152249821416L;

        DerivedMultiKey(T key1, T key2) {
            super(key1, key2);
        }

        public T getFirst() {
            return (T)this.getKey(0);
        }

        public T getSecond() {
            return (T)this.getKey(1);
        }
    }
}

