/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import org.apache.commons.collections4.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayUtilsTest {
    @Test
    public void testContains() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertFalse((boolean)ArrayUtils.contains(null, null));
        Assertions.assertFalse((boolean)ArrayUtils.contains(null, (Object)"1"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"0"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"1"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"2"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)"3"));
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, null));
        Assertions.assertFalse((boolean)ArrayUtils.contains((Object[])array, (Object)"notInArray"));
    }

    @Test
    public void testContains_LANG_1261() {
        class LANG1261ChildObject
        extends LANG1261ParentObject {
            LANG1261ChildObject() {
                class LANG1261ParentObject {
                    LANG1261ParentObject() {
                    }

                    public boolean equals(Object o) {
                        return true;
                    }

                    public int hashCode() {
                        return super.hashCode();
                    }
                }
            }
        }
        Object[] array = new LANG1261ChildObject[]{new LANG1261ChildObject()};
        Assertions.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)new LANG1261ParentObject()));
    }

    @Test
    public void testIndexOf() {
        Object[] array = new Object[]{"0", "1", "2", "3", null, "0"};
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf(null, (Object)"0"));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])new Object[0], (Object)"0"));
        Assertions.assertEquals((int)0, (int)ArrayUtils.indexOf((Object[])array, (Object)"0"));
        Assertions.assertEquals((int)1, (int)ArrayUtils.indexOf((Object[])array, (Object)"1"));
        Assertions.assertEquals((int)2, (int)ArrayUtils.indexOf((Object[])array, (Object)"2"));
        Assertions.assertEquals((int)3, (int)ArrayUtils.indexOf((Object[])array, (Object)"3"));
        Assertions.assertEquals((int)4, (int)ArrayUtils.indexOf((Object[])array, null));
        Assertions.assertEquals((int)-1, (int)ArrayUtils.indexOf((Object[])array, (Object)"notInArray"));
    }
}

