/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.map.AliasPathComponent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.AttributePathComponent;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.RelationshipPathComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathComponentIterator
implements Iterator<PathComponent<Attribute, Relationship>> {
    private StringTokenizer toks;
    private Entity currentEntity;
    private String path;
    private Map<String, String> aliasMap;

    PathComponentIterator(Entity root, String path, Map<String, String> aliasMap) {
        this.currentEntity = root;
        this.toks = new StringTokenizer(path, ".");
        this.path = path;
        this.aliasMap = aliasMap;
    }

    @Override
    public boolean hasNext() {
        return this.toks.hasMoreTokens();
    }

    @Override
    public PathComponent<Attribute, Relationship> next() {
        String aliasedPath;
        Attribute attr;
        String pathComp = this.toks.nextToken();
        JoinType relationshipJoinType = JoinType.INNER;
        if (pathComp.endsWith("+")) {
            relationshipJoinType = JoinType.LEFT_OUTER;
            pathComp = pathComp.substring(0, pathComp.length() - "+".length());
        }
        if ((attr = this.currentEntity.getAttribute(pathComp)) != null) {
            if (this.toks.hasMoreTokens()) {
                throw new ExpressionException("Attribute must be the last component of the path: '" + pathComp + "'.", this.path, null);
            }
            return new AttributePathComponent<Attribute, Relationship>(attr);
        }
        Relationship rel = this.currentEntity.getRelationship(pathComp);
        if (rel != null) {
            this.currentEntity = rel.getTargetEntity();
            return new RelationshipPathComponent<Attribute, Relationship>(rel, relationshipJoinType, !this.hasNext());
        }
        String string = aliasedPath = this.aliasMap != null ? this.aliasMap.get(pathComp) : null;
        if (aliasedPath != null) {
            PathComponentIterator subpathIt = new PathComponentIterator(this.currentEntity, aliasedPath, Collections.EMPTY_MAP);
            ArrayList parsedSubpath = new ArrayList(4);
            while (subpathIt.hasNext()) {
                PathComponent subpathComponent = (PathComponent)subpathIt.next();
                Object subpathRelationship = subpathComponent.getRelationship();
                if (subpathRelationship == null) {
                    throw this.invalidPathException("Expected a relationship in the aliased subpath. Alias [" + pathComp + "]", subpathComponent.getName());
                }
                this.currentEntity = ((Relationship)subpathRelationship).getTargetEntity();
                parsedSubpath.add(subpathComponent);
            }
            return new AliasPathComponent<Attribute, Relationship>(pathComp, parsedSubpath, !this.hasNext());
        }
        throw this.invalidPathException("Can't resolve path component", pathComp);
    }

    private ExpressionException invalidPathException(String message, String pathComponent) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(message).append(": [").append(this.currentEntity.getName()).append('.').append(pathComponent).append("].");
        return new ExpressionException(buffer.toString(), this.path, null);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("'remove' operation is not supported.");
    }
}

