/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.enhancer.CayennePojoVisitor;
import org.apache.cayenne.enhancer.EmbeddableVisitor;
import org.apache.cayenne.enhancer.EnhancerVisitorFactory;
import org.apache.cayenne.enhancer.PersistentAccessorVisitor;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.SerialVersionUIDAdder;

public class CayenneEnhancerVisitorFactory
implements EnhancerVisitorFactory {
    protected Map<String, ObjEntity> entitiesByClass;
    protected Map<String, Embeddable> embeddablesByClass;

    public CayenneEnhancerVisitorFactory(EntityResolver entityResolver) {
        this.indexEntities(entityResolver);
    }

    protected void indexEntities(EntityResolver entityResolver) {
        this.entitiesByClass = new HashMap<String, ObjEntity>();
        for (ObjEntity entity : entityResolver.getObjEntities()) {
            this.entitiesByClass.put(entity.getClassName(), entity);
        }
        this.embeddablesByClass = new HashMap<String, Embeddable>();
        for (Embeddable embeddable : entityResolver.getEmbeddables()) {
            this.embeddablesByClass.put(embeddable.getClassName(), embeddable);
        }
    }

    public ClassVisitor createVisitor(String className, ClassVisitor out) {
        String key = className.replace('/', '.');
        ObjEntity entity = this.entitiesByClass.get(key);
        if (entity != null) {
            CayennePojoVisitor e1 = new CayennePojoVisitor(out, entity);
            PersistentAccessorVisitor e2 = new PersistentAccessorVisitor((ClassVisitor)e1, entity);
            SerialVersionUIDAdder e3 = new SerialVersionUIDAdder((ClassVisitor)e2);
            return e3;
        }
        Embeddable embeddable = this.embeddablesByClass.get(key);
        if (embeddable != null) {
            EmbeddableVisitor e1 = new EmbeddableVisitor(out);
            SerialVersionUIDAdder e2 = new SerialVersionUIDAdder((ClassVisitor)e1);
            return e2;
        }
        return null;
    }
}

