/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validator;

import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.TreeNodeValidator;
import org.apache.cayenne.project.validator.Validator;
import org.apache.cayenne.util.Util;

public class EmbeddableValidator
extends TreeNodeValidator {
    public void validateObject(ProjectPath path, Validator validator) {
        Embeddable emb = (Embeddable)path.getObject();
        this.validateName(emb, path, validator);
    }

    protected void validateName(Embeddable emb, ProjectPath path, Validator validator) {
        DataDomain domain;
        String name = emb.getClassName();
        if (Util.isEmptyString(name)) {
            validator.registerError("Unnamed Embeddable.", path);
            return;
        }
        DataMap map = (DataMap)path.getObjectParent();
        if (map == null) {
            return;
        }
        for (Embeddable otherEmb : map.getEmbeddables()) {
            if (otherEmb == emb || !name.equals(otherEmb.getClassName())) continue;
            validator.registerError("Duplicate Embeddable name: " + name + ".", path);
            break;
        }
        if ((domain = path.firstInstanceOf(DataDomain.class)) != null) {
            for (DataMap nextMap : domain.getDataMaps()) {
                Embeddable conflictingEmbeddable;
                if (nextMap == map || (conflictingEmbeddable = nextMap.getEmbeddable(name)) == null) continue;
                validator.registerWarning("Duplicate Embeddable name in another DataMap: " + name + ".", path);
                break;
            }
        }
    }
}

