/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.validation.ValidationResult;

public class BigIntegerType
implements ExtendedType {
    public String getClassName() {
        return BigInteger.class.getName();
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        Object object = rs.getObject(index);
        if (object == null) {
            return null;
        }
        return new BigInteger(object.toString());
    }

    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Object object = rs.getObject(index);
        if (object == null) {
            return null;
        }
        return new BigInteger(object.toString());
    }

    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int precision) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (TypesMapping.isNumeric(type)) {
            statement.setLong(pos, ((BigInteger)value).longValue());
        } else {
            throw new IllegalArgumentException("Can't map BigInteger to a non-numeric type: " + TypesMapping.getSqlNameByType(type));
        }
    }

    public boolean validateProperty(Object source, String property, Object value, DbAttribute dbAttribute, ValidationResult validationResult) {
        return true;
    }
}

