/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.trans;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchQueryBuilder {
    protected DbAdapter adapter;
    protected String trimFunction;

    public BatchQueryBuilder() {
    }

    public BatchQueryBuilder(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public abstract String createSqlString(BatchQuery var1) throws IOException;

    protected void appendDbAttribute(StringBuffer buf, DbAttribute dbAttribute) {
        boolean trim;
        boolean bl = trim = dbAttribute.getType() == 1 && this.trimFunction != null;
        if (trim) {
            buf.append(this.trimFunction).append('(');
        }
        boolean status = dbAttribute.getEntity().getDataMap() != null && dbAttribute.getEntity().getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy strategy = this.getAdapter().getQuotingStrategy(status);
        buf.append(strategy.quoteString(dbAttribute.getName()));
        if (trim) {
            buf.append(')');
        }
    }

    public void setAdapter(DbAdapter adapter) {
        this.adapter = adapter;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public String getTrimFunction() {
        return this.trimFunction;
    }

    public void setTrimFunction(String string) {
        this.trimFunction = string;
    }

    public void bindParameters(PreparedStatement statement, BatchQuery query) throws SQLException, Exception {
        List<DbAttribute> dbAttributes = query.getDbAttributes();
        int attributeCount = dbAttributes.size();
        for (int i = 0; i < attributeCount; ++i) {
            Object value = query.getValue(i);
            DbAttribute attribute = dbAttributes.get(i);
            this.adapter.bindParameter(statement, value, i + 1, attribute.getType(), attribute.getScale());
        }
    }

    public List<Object> getParameterValues(BatchQuery query) {
        int len = query.getDbAttributes().size();
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            values.add(query.getValue(i));
        }
        return values;
    }
}

