/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.modeler.dialog.pref.TemplateCreatorView;
import org.apache.cayenne.modeler.dialog.pref.TemplatePreferences;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;

public class TemplateCreator
extends CayenneController {
    protected TemplateCreatorView view;
    protected boolean canceled;
    protected Set existingNames;
    protected PreferenceEditor editor;
    protected Domain domain;

    public TemplateCreator(TemplatePreferences parent) {
        super(parent);
        JDialog parentDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, parent.getView());
        this.view = new TemplateCreatorView(parentDialog);
        this.existingNames = new HashSet();
        this.editor = parent.getEditor();
        this.domain = parent.getTemplateDomain();
        for (FSPath path : parent.getTemplateEntries()) {
            this.existingNames.add(path.getKey());
        }
        this.initBindings();
    }

    public Component getView() {
        return this.view;
    }

    FSPath getLastTemplateDirectory() {
        FSPath path = (FSPath)this.getViewDomain().getDetail("lastTemplate", FSPath.class, true);
        if (path.getPath() == null) {
            path.setPath(this.getLastDirectory().getPath());
        }
        return path;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getOkButton(), "okAction()");
        final FSPath path = this.getLastTemplateDirectory();
        this.view.getTemplateChooser().setCurrentDirectory(path.getExistingDirectory(false));
        this.view.getTemplateChooser().addPropertyChangeListener("currentDirectory", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                File directory = TemplateCreator.this.view.getTemplateChooser().getCurrentDirectory();
                path.setDirectory(directory);
            }
        });
    }

    public void okAction() {
        String templateName = this.view.getTemplateName().getText();
        if (Util.isEmptyString((String)templateName)) {
            JOptionPane.showMessageDialog(this.view, "Enter Template Name", null, 2);
        } else if (this.existingNames.contains(templateName)) {
            JOptionPane.showMessageDialog(this.view, "'" + templateName + "' is already taken, enter a different name", null, 2);
        } else if (this.view.getTemplateChooser().getFile() == null) {
            JOptionPane.showMessageDialog(this.view, "Must select an existing template file", null, 2);
        } else {
            this.canceled = false;
            this.view.dispose();
        }
    }

    public void cancelAction() {
        this.canceled = true;
        this.view.dispose();
    }

    public FSPath startupAction() {
        this.canceled = true;
        this.view.setModal(true);
        this.view.pack();
        this.view.setResizable(false);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
        return this.createTemplate();
    }

    protected FSPath createTemplate() {
        if (this.canceled) {
            return null;
        }
        String key = this.view.getTemplateName().getText();
        File file = this.view.getTemplateChooser().getFile();
        FSPath path = (FSPath)this.editor.createDetail(this.domain, key, FSPath.class);
        path.setPath(file != null ? file.getAbsolutePath() : null);
        return path;
    }
}

