/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.DataMapEvent;
import org.apache.cayenne.map.event.DataNodeEvent;
import org.apache.cayenne.map.event.DomainEvent;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ProcedureEvent;
import org.apache.cayenne.map.event.QueryEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.undo.RemoveCompoundUndoableEdit;
import org.apache.cayenne.modeler.undo.RemoveUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.Query;

public class RemoveAction
extends CayenneAction {
    public static String getActionName() {
        return "Remove";
    }

    public RemoveAction(Application application) {
        super(RemoveAction.getActionName(), application);
    }

    protected RemoveAction(String actionName, Application application) {
        super(actionName, application);
    }

    public String getIconName() {
        return "icon-trash.gif";
    }

    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public ConfirmRemoveDialog getConfirmDeleteDialog(boolean allowAsking) {
        return new ConfirmRemoveDialog(allowAsking);
    }

    public void performAction(ActionEvent e) {
        this.performAction(e, true);
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ProjectController mediator = this.getProjectController();
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        if (mediator.getCurrentObjEntity() != null) {
            if (dialog.shouldDelete("ObjEntity", mediator.getCurrentObjEntity().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentObjEntity()));
                this.removeObjEntity(mediator.getCurrentDataMap(), mediator.getCurrentObjEntity());
            }
        } else if (mediator.getCurrentDbEntity() != null) {
            if (dialog.shouldDelete("DbEntity", mediator.getCurrentDbEntity().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentDbEntity()));
                this.removeDbEntity(mediator.getCurrentDataMap(), mediator.getCurrentDbEntity());
            }
        } else if (mediator.getCurrentQuery() != null) {
            if (dialog.shouldDelete("query", mediator.getCurrentQuery().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentQuery()));
                this.removeQuery(mediator.getCurrentDataMap(), mediator.getCurrentQuery());
            }
        } else if (mediator.getCurrentProcedure() != null) {
            if (dialog.shouldDelete("procedure", mediator.getCurrentProcedure().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentProcedure()));
                this.removeProcedure(mediator.getCurrentDataMap(), mediator.getCurrentProcedure());
            }
        } else if (mediator.getCurrentEmbeddable() != null) {
            if (dialog.shouldDelete("embeddable", mediator.getCurrentEmbeddable().getClassName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentEmbeddable()));
                this.removeEmbeddable(mediator.getCurrentDataMap(), mediator.getCurrentEmbeddable());
            }
        } else if (mediator.getCurrentDataMap() != null) {
            if (dialog.shouldDelete("data map", mediator.getCurrentDataMap().getName())) {
                if (mediator.getCurrentDataNode() != null) {
                    this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataNode(), mediator.getCurrentDataMap()));
                    this.removeDataMapFromDataNode(mediator.getCurrentDataNode(), mediator.getCurrentDataMap());
                } else {
                    this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataDomain(), mediator.getCurrentDataMap()));
                    this.removeDataMap(mediator.getCurrentDataDomain(), mediator.getCurrentDataMap());
                }
            }
        } else if (mediator.getCurrentDataNode() != null) {
            if (dialog.shouldDelete("data node", mediator.getCurrentDataNode().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataDomain(), mediator.getCurrentDataNode()));
                this.removeDataNode(mediator.getCurrentDataDomain(), mediator.getCurrentDataNode());
            }
        } else if (mediator.getCurrentDataDomain() != null) {
            if (dialog.shouldDelete("data domain", mediator.getCurrentDataDomain().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataDomain()));
                this.removeDomain(mediator.getCurrentDataDomain());
            }
        } else if (mediator.getCurrentPaths() != null && dialog.shouldDelete("selected objects")) {
            ProjectPath[] paths = mediator.getCurrentPaths();
            RemoveCompoundUndoableEdit compoundEdit = new RemoveCompoundUndoableEdit();
            for (ProjectPath path : paths) {
                compoundEdit.addEdit(this.removeLastPathComponent(path));
            }
            this.application.getUndoManager().addEdit(compoundEdit);
        }
    }

    public void removeDomain(DataDomain domain) {
        ApplicationProject project = (ApplicationProject)this.getCurrentProject();
        ProjectController mediator = this.getProjectController();
        project.getConfiguration().removeDomain(domain.getName());
        mediator.fireDomainEvent(new DomainEvent((Object)Application.getFrame(), domain, 3));
    }

    public void removeDataMap(DataDomain domain, DataMap map) {
        ProjectController mediator = this.getProjectController();
        DataMapEvent e = new DataMapEvent((Object)Application.getFrame(), map, 3);
        e.setDomain(domain);
        domain.removeMap(map.getName());
        mediator.fireDataMapEvent(e);
    }

    public void removeDataNode(DataDomain domain, DataNode node) {
        ProjectController mediator = this.getProjectController();
        DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), node, 3);
        e.setDomain(domain);
        domain.removeDataNode(node.getName());
        mediator.fireDataNodeEvent(e);
    }

    public void removeDbEntity(DataMap map, DbEntity ent) {
        ProjectController mediator = this.getProjectController();
        EntityEvent e = new EntityEvent((Object)Application.getFrame(), (Entity)ent, 3);
        e.setDomain(mediator.findDomain(map));
        map.removeDbEntity(ent.getName(), true);
        mediator.fireDbEntityEvent(e);
    }

    public void removeQuery(DataMap map, Query query) {
        ProjectController mediator = this.getProjectController();
        QueryEvent e = new QueryEvent((Object)Application.getFrame(), query, 3, map);
        e.setDomain(mediator.findDomain(map));
        map.removeQuery(query.getName());
        mediator.fireQueryEvent(e);
    }

    public void removeProcedure(DataMap map, Procedure procedure) {
        ProjectController mediator = this.getProjectController();
        ProcedureEvent e = new ProcedureEvent((Object)Application.getFrame(), procedure, 3);
        e.setDomain(mediator.findDomain(map));
        map.removeProcedure(procedure.getName());
        mediator.fireProcedureEvent(e);
    }

    public void removeObjEntity(DataMap map, ObjEntity entity) {
        ProjectController mediator = this.getProjectController();
        EntityEvent e = new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3);
        e.setDomain(mediator.findDomain(map));
        map.removeObjEntity(entity.getName(), true);
        mediator.fireObjEntityEvent(e);
        for (Query query : new ArrayList(map.getQueries())) {
            AbstractQuery next;
            Object root;
            if (!(query instanceof AbstractQuery) || (root = (next = (AbstractQuery)query).getRoot()) != entity && (!(root instanceof String) || !root.toString().equals(entity.getName()))) continue;
            this.removeQuery(map, (Query)next);
        }
    }

    public void removeEmbeddable(DataMap map, Embeddable embeddable) {
        ProjectController mediator = this.getProjectController();
        EmbeddableEvent e = new EmbeddableEvent((Object)Application.getFrame(), embeddable, 3);
        e.setDomain(mediator.findDomain(map));
        map.removeEmbeddable(embeddable.getClassName());
        mediator.fireEmbeddableEvent(e, map);
    }

    public void removeDataMapFromDataNode(DataNode node, DataMap map) {
        ProjectController mediator = this.getProjectController();
        DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), node);
        e.setDomain(mediator.findDomain(node));
        node.removeDataMap(map.getName());
        mediator.fireDataNodeEvent(e);
    }

    public boolean enableForPath(ProjectPath path) {
        if (path == null) {
            return false;
        }
        Object lastObject = path.getObject();
        if (lastObject instanceof DataDomain) {
            return true;
        }
        if (lastObject instanceof DataMap) {
            return true;
        }
        if (lastObject instanceof DataNode) {
            return true;
        }
        if (lastObject instanceof Entity) {
            return true;
        }
        if (lastObject instanceof Attribute) {
            return true;
        }
        if (lastObject instanceof Relationship) {
            return true;
        }
        if (lastObject instanceof Procedure) {
            return true;
        }
        if (lastObject instanceof ProcedureParameter) {
            return true;
        }
        if (lastObject instanceof Embeddable) {
            return true;
        }
        return lastObject instanceof EmbeddableAttribute;
    }

    private UndoableEdit removeLastPathComponent(ProjectPath path) {
        Object lastObject = path.getObject();
        RemoveUndoableEdit undo = null;
        if (lastObject instanceof DataDomain) {
            undo = new RemoveUndoableEdit(this.application, (DataDomain)lastObject);
            this.removeDomain((DataDomain)lastObject);
        } else if (lastObject instanceof DataMap) {
            Object parent = path.getObjectParent();
            if (parent instanceof DataDomain) {
                undo = new RemoveUndoableEdit(this.application, (DataDomain)parent, (DataMap)lastObject);
                this.removeDataMap((DataDomain)parent, (DataMap)lastObject);
            } else {
                undo = new RemoveUndoableEdit(this.application, (DataNode)parent, (DataMap)lastObject);
                this.removeDataMapFromDataNode((DataNode)parent, (DataMap)lastObject);
            }
        } else if (lastObject instanceof DataNode) {
            undo = new RemoveUndoableEdit(this.application, (DataDomain)path.getObjectParent(), (DataNode)lastObject);
            this.removeDataNode((DataDomain)path.getObjectParent(), (DataNode)lastObject);
        } else if (lastObject instanceof DbEntity) {
            undo = new RemoveUndoableEdit((DataMap)path.getObjectParent(), (DbEntity)lastObject);
            this.removeDbEntity((DataMap)path.getObjectParent(), (DbEntity)lastObject);
        } else if (lastObject instanceof ObjEntity) {
            undo = new RemoveUndoableEdit((DataMap)path.getObjectParent(), (ObjEntity)lastObject);
            this.removeObjEntity((DataMap)path.getObjectParent(), (ObjEntity)lastObject);
        } else if (lastObject instanceof Query) {
            undo = new RemoveUndoableEdit((DataMap)path.getObjectParent(), (Query)lastObject);
            this.removeQuery((DataMap)path.getObjectParent(), (Query)lastObject);
        } else if (lastObject instanceof Procedure) {
            undo = new RemoveUndoableEdit((DataMap)path.getObjectParent(), (Procedure)lastObject);
            this.removeProcedure((DataMap)path.getObjectParent(), (Procedure)lastObject);
        } else if (lastObject instanceof Embeddable) {
            undo = new RemoveUndoableEdit((DataMap)path.getObjectParent(), (Embeddable)lastObject);
            this.removeEmbeddable((DataMap)path.getObjectParent(), (Embeddable)lastObject);
        }
        return undo;
    }
}

