/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.model.collection;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.scopemvc.core.ModelChangeEventSource;
import org.scopemvc.core.PropertyManager;
import org.scopemvc.core.Selector;

public class ListModelSource {
    private Object listSource;
    private Selector listSourceSelector;
    private PropertyManager listModelManager;

    public ListModelSource(ModelChangeEventSource modelChangeEventSource, Selector selector) {
        this.listSource = modelChangeEventSource;
        this.listSourceSelector = selector;
        this.listModelManager = PropertyManager.getInstance(modelChangeEventSource);
    }

    public ListModelSource(Collection collection) {
        this.listSource = collection;
    }

    public ListModelSource(List list) {
        this.listSource = list;
    }

    public ListModelSource(Iterator iterator) {
        this.listSource = iterator;
    }

    public ListModelSource(Enumeration enumeration) {
        this.listSource = enumeration;
    }

    public boolean isModelBased() {
        return this.listModelManager != null;
    }

    public boolean isList() {
        return this.getListSource() instanceof List;
    }

    public ModelChangeEventSource getListSourceModel() {
        return (ModelChangeEventSource)this.listSource;
    }

    public Object getListSource() {
        if (this.isModelBased()) {
            try {
                return this.listSource == null ? null : this.listModelManager.get(this.listSource, this.listSourceSelector);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception.toString());
            }
        }
        return this.listSource;
    }

    public Selector getListSourceSelector() {
        return this.listSourceSelector;
    }

    public void addToList(List list) {
        Object object = this.getListSource();
        if (object == null) {
            return;
        }
        if (object instanceof Collection) {
            list.addAll((Collection)object);
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
        } else if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        } else if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                list.add(objectArray[n]);
                ++n;
            }
        } else {
            throw new IllegalArgumentException("Unsupported List Source: " + object.getClass());
        }
    }
}

