/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.core;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scopemvc.core.IntIndexSelector;
import org.scopemvc.core.StringIndexSelector;

public abstract class Selector {
    public static final String DELIMITER = ".";
    private static final Log LOG = LogFactory.getLog(class$org$scopemvc$core$Selector == null ? (class$org$scopemvc$core$Selector = Selector.class$("org.scopemvc.core.Selector")) : class$org$scopemvc$core$Selector);
    private Selector next;
    static /* synthetic */ Class class$org$scopemvc$core$Selector;

    Selector() {
    }

    public static IntIndexSelector fromInt(int n) {
        return new IntIndexSelector(n);
    }

    public static Selector fromString(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fromString: " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        Selector selector = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() < 1) continue;
            Selector selector2 = null;
            try {
                int n = Integer.parseInt(string2);
                selector2 = new IntIndexSelector(n);
            }
            catch (NumberFormatException numberFormatException) {
                selector2 = new StringIndexSelector(string2);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("fromString: nextToken " + string2 + ": nextSelector " + selector2);
            }
            if (selector == null) {
                selector = selector2;
            } else {
                selector.chain(selector2);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("fromString: result: " + selector);
        }
        return selector;
    }

    public static String asString(Selector selector) {
        if (selector == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Selector selector2 = selector;
        while (selector2 != null) {
            stringBuffer.append(selector2.getName());
            stringBuffer.append(DELIMITER);
            selector2 = selector2.getNext();
        }
        return stringBuffer.substring(0, stringBuffer.length() - DELIMITER.length());
    }

    public final Selector getNext() {
        return this.next;
    }

    public final Selector getLast() {
        Selector selector = this;
        while (selector.getNext() != null) {
            selector = selector.getNext();
        }
        return selector;
    }

    public abstract String getName();

    public final void chain(Selector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("Can't chain a null Selector.");
        }
        this.getLast().setNext(selector);
    }

    public final void removeLast() {
        if (this.getNext() == null) {
            throw new UnsupportedOperationException("No terminal Selector to remove");
        }
        Selector selector = this;
        while (selector.getNext().getNext() != null) {
            selector = selector.getNext();
        }
        selector.setNext(null);
    }

    public final void removeLast(Selector selector) {
        if (this.getNext() == null) {
            throw new UnsupportedOperationException("No terminal Selector to remove");
        }
        Selector selector2 = this;
        while (selector2.getNext().getNext() != null && !selector2.getNext().equals(selector)) {
            selector2 = selector2.getNext();
        }
        if (!selector2.getNext().equals(selector)) {
            throw new UnsupportedOperationException("Terminal Selector " + selector + " doesn't end Selector " + this);
        }
        selector2.setNext(null);
    }

    public final boolean startsWith(Selector selector) {
        Selector selector2 = this;
        for (Selector selector3 = selector; selector3 != null; selector3 = selector3.getNext()) {
            if (selector2 == null) {
                return false;
            }
            if (selector2.shallowEquals(selector3)) {
                selector2 = selector2.getNext();
                continue;
            }
            return false;
        }
        return true;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Selector)) {
            return false;
        }
        Selector selector = (Selector)object;
        if (!this.shallowEquals(selector)) {
            return false;
        }
        if (this.getNext() == null) {
            return selector.getNext() == null;
        }
        return this.getNext().equals(selector.getNext());
    }

    public final Selector deepClone() {
        Selector selector = this.getShallowCopy();
        if (this.getNext() != null) {
            selector.chain(this.getNext().deepClone());
        }
        return selector;
    }

    public final String toStringDescription() {
        return Selector.asString(this);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Package package_ = this.getClass().getPackage();
        if (package_ == null) {
            stringBuffer.append(this.getClass().getName());
        } else {
            stringBuffer.append(this.getClass().getName().substring(package_.getName().length() + 1));
        }
        stringBuffer.append("(");
        stringBuffer.append(Selector.asString(this));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected abstract Selector getShallowCopy();

    protected final void setNext(Selector selector) {
        this.next = selector;
    }

    protected abstract boolean shallowEquals(Selector var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

