/*
 * Decompiled with CFR 0.152.
 */
package org.scopemvc.core;

import org.scopemvc.core.ControlException;

public class Control {
    private String id;
    private Object parameter;
    private boolean matched;

    public Control(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Can't create a Control with a null ControlID");
        }
        this.matched = false;
        this.id = string;
    }

    public Control(String string, Object object) {
        this(string);
        this.parameter = object;
    }

    public final String getID() {
        return this.id;
    }

    public final String getName() {
        return this.id;
    }

    public final boolean isMatched() {
        return this.matched;
    }

    public final Object getParameter() {
        return this.parameter;
    }

    public final void setParameter(Object object) {
        this.parameter = object;
    }

    public final void markUnmatched() {
        this.matched = false;
    }

    public final void markMatched() {
        this.matched = true;
    }

    public final boolean matchesID(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Can't match against a null ID.");
        }
        if (this.matched) {
            throw new RuntimeException("Already matched this Control once.");
        }
        this.matched = this.id.equals(string);
        return this.matched;
    }

    public void populateControlException(ControlException controlException) {
        controlException.setSourceControlID(this.id);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Control)) {
            return false;
        }
        Control control = (Control)object;
        return this.id.equals(control.id) && this.parameter == null && control.parameter == null || this.parameter != null && this.parameter.equals(control.parameter);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Control(" + this.id + "," + this.parameter + ")";
    }
}

