/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.combo;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ComboBoxCellEditor
extends AbstractCellEditor
implements ActionListener,
TableCellEditor,
FocusListener,
Serializable {
    static final String IS_TABLE_CELL_EDITOR_PROPERTY = "JComboBox.isTableCellEditor";
    private final JComboBox comboBox;

    public ComboBoxCellEditor(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.comboBox.putClientProperty(IS_TABLE_CELL_EDITOR_PROPERTY, Boolean.TRUE);
        this.comboBox.addActionListener(this);
        this.comboBox.getEditor().getEditorComponent().addFocusListener(this);
        ((JComponent)comboBox.getEditor().getEditorComponent()).setBorder(null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("comboBoxEdited")) {
            this.stopCellEditing();
        }
    }

    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    public boolean stopCellEditing() {
        if (this.comboBox.isEditable()) {
            this.comboBox.actionPerformed(new ActionEvent(this, 0, ""));
        }
        this.fireEditingStopped();
        return true;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.comboBox.setSelectedItem(value);
        return this.comboBox;
    }

    public boolean isCellEditable(EventObject e) {
        MouseEvent me;
        return !(e instanceof MouseEvent) || !(me = (MouseEvent)e).isControlDown() && !me.isShiftDown();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getOppositeComponent() != null) {
            this.stopCellEditing();
        }
    }
}

