/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.StringTokenizer;
import javax.swing.border.Border;

public final class Borders {
    public static final Border EMPTY_BORDER = new javax.swing.border.EmptyBorder(0, 0, 0, 0);
    public static final Border DLU2_BORDER = Borders.createEmptyBorder(Sizes.DLUY2, Sizes.DLUX2, Sizes.DLUY2, Sizes.DLUX2);
    public static final Border DLU4_BORDER = Borders.createEmptyBorder(Sizes.DLUY4, Sizes.DLUX4, Sizes.DLUY4, Sizes.DLUX4);
    public static final Border DLU7_BORDER = Borders.createEmptyBorder(Sizes.DLUY7, Sizes.DLUX7, Sizes.DLUY7, Sizes.DLUX7);
    public static final Border DLU14_BORDER = Borders.createEmptyBorder(Sizes.DLUY14, Sizes.DLUX14, Sizes.DLUY14, Sizes.DLUX14);
    public static final Border BUTTON_BAR_GAP_BORDER = Borders.createEmptyBorder(LayoutStyle.getCurrent().getButtonBarPad(), Sizes.dluX(0), Sizes.dluY(0), Sizes.dluX(0));
    public static final Border DIALOG_BORDER = Borders.createEmptyBorder(LayoutStyle.getCurrent().getDialogMarginY(), LayoutStyle.getCurrent().getDialogMarginX(), LayoutStyle.getCurrent().getDialogMarginY(), LayoutStyle.getCurrent().getDialogMarginX());
    public static final Border TABBED_DIALOG_BORDER = Borders.createEmptyBorder(LayoutStyle.getCurrent().getTabbedDialogMarginY(), LayoutStyle.getCurrent().getTabbedDialogMarginX(), LayoutStyle.getCurrent().getTabbedDialogMarginY(), LayoutStyle.getCurrent().getTabbedDialogMarginX());

    public static Border createEmptyBorder(ConstantSize top, ConstantSize left, ConstantSize bottom, ConstantSize right) {
        return new EmptyBorder(top, left, bottom, right);
    }

    public static Border createEmptyBorder(String encodedSizes) {
        StringTokenizer tokenizer = new StringTokenizer(encodedSizes, ", ");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount != 4) {
            throw new IllegalArgumentException("The border requires 4 sizes, but '" + encodedSizes + "' has " + tokenCount + ".");
        }
        ConstantSize top = Sizes.constant(tokenizer.nextToken(), false);
        ConstantSize left = Sizes.constant(tokenizer.nextToken(), true);
        ConstantSize bottom = Sizes.constant(tokenizer.nextToken(), false);
        ConstantSize right = Sizes.constant(tokenizer.nextToken(), true);
        return Borders.createEmptyBorder(top, left, bottom, right);
    }

    public static final class EmptyBorder
    implements Border {
        private final ConstantSize top;
        private final ConstantSize left;
        private final ConstantSize bottom;
        private final ConstantSize right;

        private EmptyBorder(ConstantSize top, ConstantSize left, ConstantSize bottom, ConstantSize right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        public ConstantSize top() {
            return this.top;
        }

        public ConstantSize left() {
            return this.left;
        }

        public ConstantSize bottom() {
            return this.bottom;
        }

        public ConstantSize right() {
            return this.right;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(this.top.getPixelSize(c), this.left.getPixelSize(c), this.bottom.getPixelSize(c), this.right.getPixelSize(c));
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

