/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.util.ModelerUtil;

public class DbImportTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected DbImportTreeNode node;
    private Map<Class, String> icons;
    private Map<Class, String> transferableTreeIcons;

    public DbImportTreeCellRenderer() {
        this.initIcons();
        this.initTrasferableTreeIcons();
    }

    private void initTrasferableTreeIcons() {
        this.transferableTreeIcons = new HashMap<Class, String>();
        this.transferableTreeIcons.put(Catalog.class, "icon-dbi-catalog.png");
        this.transferableTreeIcons.put(Schema.class, "icon-dbi-schema.png");
        this.transferableTreeIcons.put(IncludeTable.class, "icon-dbentity.png");
        this.transferableTreeIcons.put(IncludeProcedure.class, "icon-stored-procedure.png");
        this.transferableTreeIcons.put(IncludeColumn.class, "icon-dbi-column.png");
    }

    private void initIcons() {
        this.icons = new HashMap<Class, String>();
        this.icons.put(Catalog.class, "icon-dbi-catalog.png");
        this.icons.put(Schema.class, "icon-dbi-schema.png");
        this.icons.put(IncludeTable.class, "icon-dbi-includeTable.png");
        this.icons.put(ExcludeTable.class, "icon-dbi-excludeTable.png");
        this.icons.put(IncludeColumn.class, "icon-dbi-includeColumn.png");
        this.icons.put(ExcludeColumn.class, "icon-dbi-excludeColumn.png");
        this.icons.put(IncludeProcedure.class, "icon-dbi-includeProcedure.png");
        this.icons.put(ExcludeProcedure.class, "icon-dbi-excludeProcedure.png");
    }

    private ImageIcon getIconByNodeType(Class nodeClass, boolean isTransferable) {
        String iconName;
        String string = iconName = !isTransferable ? this.icons.get(nodeClass) : this.transferableTreeIcons.get(nodeClass);
        if (iconName == null) {
            return null;
        }
        return ModelerUtil.buildIcon(iconName);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.node = (DbImportTreeNode)value;
        this.setIcon(this.getIconByNodeType(this.node.getUserObject().getClass(), ((DbImportTree)tree).isTransferable()));
        return this;
    }
}

