/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.Relationship;

class PrefetchModel
extends AbstractTableModel {
    private final Map<String, Integer> prefetchMap;
    private final Object root;
    private final String[] prefetches;

    PrefetchModel(Map<String, Integer> prefetchMap, Object root) {
        this.prefetchMap = prefetchMap;
        this.prefetches = prefetchMap.keySet().toArray(new String[0]);
        this.root = root;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.prefetches != null ? this.prefetches.length : 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.prefetches[row];
            }
            case 1: {
                return this.isToMany(this.prefetches[row]) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return PrefetchModel.getPrefetchTypeString(this.prefetchMap.get(this.prefetches[row]));
            }
        }
        throw new IndexOutOfBoundsException("Invalid column: " + column);
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
        }
        throw new IndexOutOfBoundsException("Invalid column: " + column);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Prefetch Path";
            }
            case 1: {
                return "To Many";
            }
            case 2: {
                return "Prefetch Type";
            }
        }
        throw new IndexOutOfBoundsException("Invalid column: " + column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 2: {
                this.prefetchMap.put(this.prefetches[row], PrefetchModel.getPrefetchType((String)value));
            }
        }
    }

    static int getPrefetchType(String semantics) {
        switch (semantics) {
            case "Joint": {
                return 1;
            }
            case "Disjoint": {
                return 2;
            }
            case "Disjoint by id": {
                return 3;
            }
        }
        return 0;
    }

    private static String getPrefetchTypeString(int semantics) {
        switch (semantics) {
            case 1: {
                return "Joint";
            }
            case 2: {
                return "Disjoint";
            }
            case 3: {
                return "Disjoint by id";
            }
        }
        return "Undefined semantics";
    }

    private boolean isToMany(String prefetch) {
        try {
            Expression exp = ExpressionFactory.exp(prefetch, new Object[0]);
            Object object = exp.evaluate(this.root);
            return object instanceof Relationship && ((Relationship)object).isToMany();
        }
        catch (ExpressionException e) {
            return false;
        }
    }
}

