/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.external.dataset.adapter.AdapterIdentifier;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Database;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.runtime.fulltext.AbstractFullTextFilterDescriptor;
import org.apache.asterix.runtime.fulltext.FullTextConfigDescriptor;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.FullTextFilterType;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextFilterEvaluatorFactory;

public class MetadataTransactionContext
extends MetadataCache {
    protected MetadataCache droppedCache = new MetadataCache();
    protected ArrayList<MetadataCache.MetadataLogicalOperation> opLog = new ArrayList();
    private final TxnId txnId;

    public MetadataTransactionContext(TxnId txnId) {
        this.txnId = txnId;
    }

    public TxnId getTxnId() {
        return this.txnId;
    }

    public void addDatabase(Database database) {
        this.droppedCache.dropDatabase(database);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(database, true));
    }

    public void addDataverse(Dataverse dataverse) {
        this.droppedCache.dropDataverse(dataverse);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(dataverse, true));
    }

    public void addDataset(Dataset dataset) {
        this.droppedCache.dropDataset(dataset);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(dataset, true));
    }

    public void addIndex(Index index) {
        this.droppedCache.dropIndex(index);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(index, true));
    }

    public void addDatatype(Datatype datatype) {
        this.droppedCache.dropDatatype(datatype);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(datatype, true));
    }

    public void addNodeGroup(NodeGroup nodeGroup) {
        this.droppedCache.dropNodeGroup(nodeGroup);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(nodeGroup, true));
    }

    public void addFunction(Function function) {
        this.droppedCache.dropFunction(function);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(function, true));
    }

    public void addFullTextFilter(FullTextFilterMetadataEntity filterMetadataEntity) {
        this.droppedCache.dropFullTextFilter(filterMetadataEntity);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(filterMetadataEntity, true));
    }

    public void addFullTextConfig(FullTextConfigMetadataEntity configMetadataEntity) {
        this.droppedCache.dropFullTextConfig(configMetadataEntity);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(configMetadataEntity, true));
    }

    public void addAdapter(DatasourceAdapter adapter) {
        this.droppedCache.dropAdapterIfExists(adapter);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(adapter, true));
    }

    public void addCompactionPolicy(CompactionPolicy compactionPolicy) {
        this.droppedCache.dropCompactionPolicy(compactionPolicy);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(compactionPolicy, true));
    }

    public void addLibrary(Library library) {
        this.droppedCache.dropLibrary(library);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(library, true));
    }

    public void addFeedPolicy(FeedPolicyEntity feedPolicy) {
        this.droppedCache.dropFeedPolicy(feedPolicy);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feedPolicy, true));
    }

    public void addFeed(Feed feed) {
        this.droppedCache.dropFeedIfExists(feed);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feed, true));
    }

    public void addFeedConnection(FeedConnection feedConnection) {
        this.droppedCache.dropFeedConnection(feedConnection);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feedConnection, true));
    }

    public void dropDataset(String database, DataverseName dataverseName, String datasetName) {
        Dataset dataset = new Dataset(database, dataverseName, datasetName, null, null, null, null, null, null, null, null, null, -1, 0);
        this.droppedCache.addDatasetIfNotExists(dataset);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(dataset, false));
    }

    public void dropIndex(String database, DataverseName dataverseName, String datasetName, String indexName) {
        Index index = new Index(database, dataverseName, datasetName, indexName, null, null, false, false, 0);
        this.droppedCache.addIndexIfNotExists(index);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(index, false));
    }

    public void dropDatabase(String databaseName) {
        Database database = new Database(databaseName, false, 0);
        this.droppedCache.addDatabaseIfNotExists(database);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(database, false));
    }

    public void dropDataverse(String database, DataverseName dataverseName) {
        Dataverse dataverse = new Dataverse(database, dataverseName, null, 0);
        this.droppedCache.addDataverseIfNotExists(dataverse);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(dataverse, false));
    }

    public void dropDataDatatype(String database, DataverseName dataverseName, String datatypeName) {
        Datatype datatype = new Datatype(database, dataverseName, datatypeName, null, false);
        this.droppedCache.addDatatypeIfNotExists(datatype);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(datatype, false));
    }

    public void dropNodeGroup(String nodeGroupName) {
        NodeGroup nodeGroup = new NodeGroup(nodeGroupName, null);
        this.droppedCache.addOrUpdateNodeGroup(nodeGroup);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(nodeGroup, false));
    }

    public void dropFunction(FunctionSignature signature) {
        Function function = new Function(signature, null, null, null, null, null, null, null, null, null, null, false, false, null, null);
        this.droppedCache.addFunctionIfNotExists(function);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(function, false));
    }

    public void dropFullTextConfig(String database, DataverseName dataverseName, String configName) {
        FullTextConfigDescriptor config = new FullTextConfigDescriptor(database, dataverseName, configName, null, null);
        FullTextConfigMetadataEntity configMetadataEntity = new FullTextConfigMetadataEntity(config);
        this.droppedCache.addFullTextConfigIfNotExists(configMetadataEntity);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(configMetadataEntity, false));
    }

    public void dropFullTextFilter(String database, DataverseName dataverseName, String filterName) {
        AbstractFullTextFilterDescriptor filter = new AbstractFullTextFilterDescriptor(database, dataverseName, filterName){
            private static final long serialVersionUID = -8222222581298765902L;

            public FullTextFilterType getFilterType() {
                return null;
            }

            public IFullTextFilterEvaluatorFactory createEvaluatorFactory() {
                return null;
            }
        };
        FullTextFilterMetadataEntity filterMetadataEntity = new FullTextFilterMetadataEntity(filter);
        this.droppedCache.addFullTextFilterIfNotExists(filterMetadataEntity);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(filterMetadataEntity, false));
    }

    public void dropAdapter(String database, DataverseName dataverseName, String adapterName) {
        AdapterIdentifier adapterIdentifier = new AdapterIdentifier(database, dataverseName, adapterName);
        DatasourceAdapter adapter = new DatasourceAdapter(adapterIdentifier, null, null, null, null, null);
        this.droppedCache.addAdapterIfNotExists(adapter);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(adapter, false));
    }

    public void dropLibrary(String database, DataverseName dataverseName, String libraryName) {
        Library library = new Library(database, dataverseName, libraryName, null, null, 0);
        this.droppedCache.addLibraryIfNotExists(library);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(library, false));
    }

    public void dropFeed(Feed feed) {
        this.droppedCache.addFeedIfNotExists(feed);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feed, false));
    }

    public void dropFeedConnection(String database, DataverseName dataverseName, String feedName, String datasetName) {
        FeedConnection feedConnection = new FeedConnection(database, dataverseName, feedName, datasetName, null, null, null, null);
        this.droppedCache.addFeedConnectionIfNotExists(feedConnection);
        this.logAndApply(new MetadataCache.MetadataLogicalOperation(feedConnection, false));
    }

    public void logAndApply(MetadataCache.MetadataLogicalOperation op) {
        this.opLog.add(op);
        this.doOperation(op);
    }

    public boolean databaseIsDropped(String databaseName) {
        return this.droppedCache.getDatabase(databaseName) != null;
    }

    public boolean dataverseIsDropped(String databaseName, DataverseName dataverseName) {
        if (this.droppedCache.getDatabase(databaseName) != null) {
            return true;
        }
        return this.droppedCache.getDataverse(databaseName, dataverseName) != null;
    }

    public boolean datasetIsDropped(String databaseName, DataverseName dataverseName, String datasetName) {
        if (this.droppedCache.getDatabase(databaseName) != null) {
            return true;
        }
        if (this.droppedCache.getDataverse(databaseName, dataverseName) != null) {
            return true;
        }
        return this.droppedCache.getDataset(databaseName, dataverseName, datasetName) != null;
    }

    public boolean indexIsDropped(String databaseName, DataverseName dataverseName, String datasetName, String indexName) {
        if (this.droppedCache.getDatabase(databaseName) != null) {
            return true;
        }
        if (this.droppedCache.getDataverse(databaseName, dataverseName) != null) {
            return true;
        }
        if (this.droppedCache.getDataset(databaseName, dataverseName, datasetName) != null) {
            return true;
        }
        return this.droppedCache.getIndex(databaseName, dataverseName, datasetName, indexName) != null;
    }

    public boolean datatypeIsDropped(String databaseName, DataverseName dataverseName, String datatypeName) {
        if (this.droppedCache.getDatabase(databaseName) != null) {
            return true;
        }
        if (this.droppedCache.getDataverse(databaseName, dataverseName) != null) {
            return true;
        }
        return this.droppedCache.getDatatype(databaseName, dataverseName, datatypeName) != null;
    }

    public boolean nodeGroupIsDropped(String nodeGroup) {
        return this.droppedCache.getNodeGroup(nodeGroup) != null;
    }

    public boolean functionIsDropped(FunctionSignature functionSignature) {
        return this.droppedCache.getFunction(functionSignature) != null;
    }

    public boolean fullTextConfigIsDropped(String databaseName, DataverseName dataverseName, String configName) {
        return this.droppedCache.getFullTextConfig(databaseName, dataverseName, configName) != null;
    }

    public boolean fullTextFilterIsDropped(String databaseName, DataverseName dataverseName, String filterName) {
        return this.droppedCache.getFullTextFilter(databaseName, dataverseName, filterName) != null;
    }

    public List<MetadataCache.MetadataLogicalOperation> getOpLog() {
        return this.opLog;
    }

    @Override
    public void clear() {
        super.clear();
        this.droppedCache.clear();
        this.opLog.clear();
    }
}

