/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.cluster.ComputePartition;
import org.apache.asterix.common.cluster.IClusterStateManager;

public class StorageComputePartitionsMap {
    private final Map<Integer, ComputePartition> storageComputeMap = new HashMap<Integer, ComputePartition>();
    private final int storagePartitionsCount;

    public StorageComputePartitionsMap(int storagePartitionsCount) {
        this.storagePartitionsCount = storagePartitionsCount;
    }

    public void addStoragePartition(int stoPart, ComputePartition compute) {
        this.storageComputeMap.put(stoPart, compute);
    }

    public int[][] getComputeToStorageMap(boolean metadataDataset) {
        LinkedHashMap<Integer, List> computeToStoragePartitions = new LinkedHashMap<Integer, List>();
        if (metadataDataset) {
            boolean computePartitionIdForMetadata = false;
            computeToStoragePartitions.put(0, Collections.singletonList(0));
        } else {
            for (int i2 = 0; i2 < this.storagePartitionsCount; ++i2) {
                ComputePartition computePartition = this.getComputePartition(i2);
                int computeId = computePartition.getId();
                List storagePartitions = computeToStoragePartitions.computeIfAbsent(computeId, k -> new ArrayList());
                storagePartitions.add(i2);
            }
        }
        int[][] computeToStoArray = new int[computeToStoragePartitions.size()][];
        int partitionIdx = 0;
        for (Map.Entry computeToStoPartitions : computeToStoragePartitions.entrySet()) {
            computeToStoArray[partitionIdx] = ((List)computeToStoPartitions.getValue()).stream().mapToInt(i -> i).toArray();
            ++partitionIdx;
        }
        return computeToStoArray;
    }

    public int getStoragePartitionsCount() {
        return this.storagePartitionsCount;
    }

    public ComputePartition getComputePartition(int storagePartition) {
        return this.storageComputeMap.get(storagePartition);
    }

    public Set<String> getComputeNodes() {
        return this.storageComputeMap.values().stream().map(ComputePartition::getNodeId).collect(Collectors.toSet());
    }

    public Set<Integer> getStoragePartitions(Set<Integer> computePartitions) {
        HashSet<Integer> storagePartitions = new HashSet<Integer>();
        for (Map.Entry<Integer, ComputePartition> entry : this.storageComputeMap.entrySet()) {
            ComputePartition computePartition = entry.getValue();
            if (!computePartitions.contains(computePartition.getId())) continue;
            storagePartitions.add(entry.getKey());
        }
        return storagePartitions;
    }

    public static StorageComputePartitionsMap computePartitionsMap(IClusterStateManager clusterStateManager) {
        ClusterPartition metadataPartition = clusterStateManager.getMetadataPartition();
        Map<Integer, ClusterPartition> clusterPartitions = clusterStateManager.getClusterPartitions();
        int storagePartitionsCount = clusterStateManager.getStoragePartitionsCount();
        StorageComputePartitionsMap newMap = new StorageComputePartitionsMap(storagePartitionsCount);
        newMap.addStoragePartition(metadataPartition.getPartitionId(), new ComputePartition(metadataPartition.getPartitionId(), metadataPartition.getActiveNodeId()));
        int storagePartitionsPerComputePartition = storagePartitionsCount / clusterPartitions.size();
        int storagePartitionId = 0;
        int lastComputePartition = 1;
        int remainingStoragePartition = storagePartitionsCount % clusterPartitions.size();
        for (Map.Entry<Integer, ClusterPartition> cp : clusterPartitions.entrySet()) {
            ClusterPartition clusterPartition = cp.getValue();
            for (int i = 0; i < storagePartitionsPerComputePartition; ++i) {
                newMap.addStoragePartition(storagePartitionId, new ComputePartition(clusterPartition.getPartitionId(), clusterPartition.getActiveNodeId()));
                ++storagePartitionId;
            }
            if (lastComputePartition == clusterPartitions.size() && remainingStoragePartition != 0) {
                for (int k = 0; k < remainingStoragePartition; ++k) {
                    newMap.addStoragePartition(storagePartitionId, new ComputePartition(clusterPartition.getPartitionId(), clusterPartition.getActiveNodeId()));
                    ++storagePartitionId;
                }
            }
            ++lastComputePartition;
        }
        return newMap;
    }
}

