/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.converter;

import java.util.Arrays;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IRecordConverter;
import org.apache.asterix.external.input.record.RecordWithMetadataAndPK;
import org.apache.asterix.external.input.record.converter.CSVToRecordWithMetadataAndPKConverter;
import org.apache.asterix.external.input.record.converter.IRecordConverterFactory;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;

public class CSVWithRecordConverterFactory
implements IRecordConverterFactory<char[], RecordWithMetadataAndPK<char[]>> {
    private static final long serialVersionUID = 1L;
    private int recordIndex;
    private char delimiter;
    private ARecordType metaType;
    private ARecordType recordType;
    private int[] keyIndicators;
    private int[] keyIndexes;
    private IAType[] keyTypes;

    @Override
    public IRecordConverter<char[], RecordWithMetadataAndPK<char[]>> createConverter(IExternalDataRuntimeContext context) {
        return new CSVToRecordWithMetadataAndPKConverter(this.recordIndex, this.delimiter, this.metaType, this.recordType, this.keyIndicators, this.keyIndexes, this.keyTypes, context);
    }

    @Override
    public void configure(Map<String, String> configuration) throws AsterixException {
        String property = configuration.get("record-index");
        if (property == null) {
            throw new AsterixException("Unspecified record-index for csv to csv with record converter");
        }
        this.recordIndex = Integer.parseInt(property);
        property = configuration.get("delimiter");
        if (property == null) {
            throw new AsterixException("Unspecified delimiter for csv to csv with record converter");
        }
        if (property.trim().length() > 1) {
            throw new AsterixException("Large delimiter. The maximum delimiter size = 1");
        }
        this.delimiter = property.trim().charAt(0);
        property = configuration.get("key-indexes");
        if (property == null) {
            this.keyIndexes = null;
            this.keyIndicators = null;
            this.keyTypes = null;
        } else {
            String[] indexes = property.split(",");
            this.keyIndexes = new int[indexes.length];
            for (int i = 0; i < this.keyIndexes.length; ++i) {
                this.keyIndexes[i] = Integer.parseInt(indexes[i].trim());
            }
            property = configuration.get("key-indicators");
            if (property == null) {
                this.keyIndicators = new int[this.keyIndexes.length];
                Arrays.fill(this.keyIndicators, 1);
            } else {
                int i;
                this.keyIndicators = new int[this.keyIndexes.length];
                String[] indicators = property.split(",");
                for (i = 0; i < this.keyIndicators.length; ++i) {
                    this.keyIndicators[i] = Integer.parseInt(indicators[i].trim());
                    if (this.keyIndicators[i] <= 1 && this.keyIndicators[i] >= 0) continue;
                    throw new AsterixException("Invalid key-indicators value. Allowed values are only 0 and 1.");
                }
                this.keyTypes = new IAType[this.keyIndexes.length];
                for (i = 0; i < this.keyIndicators.length; ++i) {
                    this.keyTypes[i] = this.keyIndicators[i] == 0 ? this.recordType.getFieldTypes()[this.keyIndexes[i]] : this.metaType.getFieldTypes()[this.keyIndexes[i]];
                }
            }
        }
    }

    @Override
    public Class<?> getInputClass() {
        return char[].class;
    }

    @Override
    public Class<?> getOutputClass() {
        return char[].class;
    }

    @Override
    public void setRecordType(ARecordType recordType) {
        this.recordType = recordType;
    }

    @Override
    public void setMetaType(ARecordType metaType) {
        this.metaType = metaType;
    }
}

