/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

final class DateTimeRfc1123Serializer
extends JsonSerializer<DateTimeRfc1123> {
    DateTimeRfc1123Serializer() {
    }

    public static SimpleModule getModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(DateTimeRfc1123.class, (JsonSerializer)new DateTimeRfc1123Serializer());
        return module;
    }

    public void serialize(DateTimeRfc1123 value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jgen.writeNumber(value.getDateTime().toInstant().toEpochMilli());
        } else {
            jgen.writeString(value.toString());
        }
    }
}

