/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.column.impls.btree;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTreeCursorInitialState;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleMode;
import org.apache.hyracks.storage.am.common.ophelpers.FindTupleNoExactMatchPolicy;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnReadMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnTupleIterator;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;
import org.apache.hyracks.storage.common.EnforcedIndexCursor;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class ColumnBTreeRangeSearchCursor
extends EnforcedIndexCursor
implements ITreeIndexCursor,
IColumnReadMultiPageOp {
    protected final ColumnBTreeReadLeafFrame frame;
    protected final IColumnTupleIterator frameTuple;
    protected IBufferCache bufferCache = null;
    protected int fileId;
    protected int pageId;
    protected ICachedPage page0 = null;
    protected final RangePredicate reusablePredicate;
    protected MultiComparator originalKeyCmp;
    protected RangePredicate pred;
    protected ITupleReference lowKey;
    protected ITupleReference highKey;
    protected FindTupleMode lowKeyFtm;
    protected FindTupleMode highKeyFtm;
    protected FindTupleNoExactMatchPolicy lowKeyFtp;
    protected FindTupleNoExactMatchPolicy highKeyFtp;
    protected boolean yieldFirstCall;
    protected final IIndexCursorStats stats;

    public ColumnBTreeRangeSearchCursor(ColumnBTreeReadLeafFrame frame, IIndexCursorStats stats, int index) {
        this.frame = frame;
        this.frameTuple = frame.createTupleReference(index, this);
        this.reusablePredicate = new RangePredicate();
        this.stats = stats;
        this.fileId = -1;
        this.pageId = -1;
    }

    public void doDestroy() {
    }

    public ITupleReference doGetTuple() {
        return this.frameTuple;
    }

    private void fetchNextLeafPage(int leafPage) throws HyracksDataException {
        int nextLeafPage = leafPage;
        do {
            ICachedPage nextLeaf = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)nextLeafPage), false);
            this.stats.getPageCounter().update(1L);
            this.bufferCache.unpin(this.page0);
            this.page0 = nextLeaf;
            this.frame.setPage(this.page0);
            this.frameTuple.newPage();
            this.setCursorPosition();
            nextLeafPage = this.frame.getNextLeaf();
        } while (this.frame.getTupleCount() == 0 && nextLeafPage > 0);
    }

    public boolean doHasNext() throws HyracksDataException {
        if (this.frameTuple.isConsumed() && !this.yieldFirstCall) {
            this.frameTuple.lastTupleReached();
            int nextLeafPage = this.frame.getNextLeaf();
            if (nextLeafPage >= 0) {
                this.fetchNextLeafPage(nextLeafPage);
            } else {
                return false;
            }
        }
        return this.isNextIncluded();
    }

    public void doNext() throws HyracksDataException {
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.page0 != null) {
            this.releasePages();
        }
        this.originalKeyCmp = initialState.getOriginalKeyComparator();
        this.page0 = initialState.getPage();
        this.pageId = ((BTreeCursorInitialState)initialState).getPageId();
        this.frame.setPage(this.page0);
        this.frame.setMultiComparator(this.originalKeyCmp);
        if (this.frame.getTupleCount() > 0) {
            this.frameTuple.newPage();
            this.initCursorPosition(searchPred);
        } else {
            this.yieldFirstCall = false;
            this.frameTuple.consume();
        }
    }

    protected void initCursorPosition(ISearchPredicate searchPred) throws HyracksDataException {
        this.setSearchPredicate(searchPred);
        this.reusablePredicate.setLowKeyComparator(this.originalKeyCmp);
        this.reusablePredicate.setHighKeyComparator(this.pred.getHighKeyComparator());
        this.reusablePredicate.setHighKey(this.pred.getHighKey(), this.pred.isHighKeyInclusive());
        this.yieldFirstCall = false;
        this.setCursorPosition();
    }

    private void setCursorPosition() throws HyracksDataException {
        int start = this.getLowKeyIndex();
        int end = this.getHighKeyIndex();
        if (end < start) {
            this.frameTuple.consume();
            return;
        }
        this.frameTuple.reset(start, end);
        this.yieldFirstCall = this.shouldYieldFirstCall();
    }

    protected boolean isNextIncluded() throws HyracksDataException {
        if (this.yieldFirstCall) {
            this.yieldFirstCall = false;
            return true;
        }
        if (this.frameTuple.isConsumed()) {
            return false;
        }
        this.frameTuple.next();
        return this.highKey == null || this.isLessOrEqual((ITupleReference)this.frameTuple, this.highKey, this.pred.isHighKeyInclusive(), this.pred.getHighKeyComparator());
    }

    protected boolean shouldYieldFirstCall() throws HyracksDataException {
        return this.highKey == null || this.isLessOrEqual((ITupleReference)this.frameTuple, this.highKey, this.pred.isHighKeyInclusive(), this.pred.getHighKeyComparator());
    }

    protected void releasePages() throws HyracksDataException {
        this.frameTuple.unpinColumnsPages();
        if (this.page0 != null) {
            this.bufferCache.unpin(this.page0);
        }
    }

    private boolean isLessOrEqual(ITupleReference left, ITupleReference right, boolean inclusive, MultiComparator comparator) throws HyracksDataException {
        int cmp = comparator.compare(left, right);
        return cmp < 0 || inclusive && cmp == 0;
    }

    protected int getLowKeyIndex() throws HyracksDataException {
        if (this.lowKey == null) {
            return 0;
        }
        if (this.isLessOrEqual(this.frame.getRightmostTuple(), this.lowKey, !this.pred.isLowKeyInclusive(), this.pred.getLowKeyComparator())) {
            return this.frame.getTupleCount();
        }
        int index = this.frameTuple.findTupleIndex(this.lowKey, this.pred.getLowKeyComparator(), this.lowKeyFtm, this.lowKeyFtp);
        if (this.pred.isLowKeyInclusive()) {
            ++index;
        } else if (index < 0) {
            index = this.frame.getTupleCount();
        }
        return index;
    }

    protected int getHighKeyIndex() throws HyracksDataException {
        if (this.highKey == null) {
            return this.frame.getTupleCount() - 1;
        }
        if (this.isLessOrEqual(this.highKey, this.frame.getLeftmostTuple(), !this.pred.isHighKeyInclusive(), this.pred.getHighKeyComparator())) {
            return -1;
        }
        int index = this.frameTuple.findTupleIndex(this.highKey, this.pred.getHighKeyComparator(), this.highKeyFtm, this.highKeyFtp);
        if (this.pred.isHighKeyInclusive()) {
            index = index < 0 ? this.frame.getTupleCount() - 1 : --index;
        }
        return index;
    }

    protected void setSearchPredicate(ISearchPredicate searchPred) {
        this.pred = (RangePredicate)searchPred;
        this.lowKey = this.pred.getLowKey();
        this.highKey = this.pred.getHighKey();
        this.lowKeyFtm = FindTupleMode.EXCLUSIVE;
        this.lowKeyFtp = this.pred.isLowKeyInclusive() ? FindTupleNoExactMatchPolicy.LOWER_KEY : FindTupleNoExactMatchPolicy.HIGHER_KEY;
        this.highKeyFtm = FindTupleMode.EXCLUSIVE;
        this.highKeyFtp = this.pred.isHighKeyInclusive() ? FindTupleNoExactMatchPolicy.HIGHER_KEY : FindTupleNoExactMatchPolicy.LOWER_KEY;
    }

    public void doClose() throws HyracksDataException {
        this.releasePages();
        this.frameTuple.close();
        this.page0 = null;
        this.pred = null;
    }

    public void setBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public boolean isExclusiveLatchNodes() {
        return false;
    }

    @Override
    public ICachedPage pin(int pageId) throws HyracksDataException {
        this.stats.getPageCounter().update(1L);
        return this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
    }

    @Override
    public void unpin(ICachedPage page) throws HyracksDataException {
        this.bufferCache.unpin(page);
    }

    @Override
    public int getPageSize() {
        return this.bufferCache.getPageSize();
    }
}

