/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud;

import org.apache.asterix.cloud.AbstractCloudIOManager;
import org.apache.asterix.cloud.EagerCloudIOManager;
import org.apache.asterix.cloud.LazyCloudIOManager;
import org.apache.asterix.common.api.INamespacePathResolver;
import org.apache.asterix.common.cloud.CloudCachePolicy;
import org.apache.asterix.common.cloud.IPartitionBootstrapper;
import org.apache.asterix.common.config.CloudProperties;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.control.nc.io.IOManager;

public class CloudManagerProvider {
    private CloudManagerProvider() {
    }

    public static IIOManager createIOManager(CloudProperties cloudProperties, IIOManager ioManager, INamespacePathResolver nsPathResolver) throws HyracksDataException {
        IOManager localIoManager = (IOManager)ioManager;
        if (cloudProperties.getCloudCachePolicy() == CloudCachePolicy.LAZY) {
            return new LazyCloudIOManager(localIoManager, cloudProperties, nsPathResolver);
        }
        return new EagerCloudIOManager(localIoManager, cloudProperties, nsPathResolver);
    }

    public static IPartitionBootstrapper getCloudPartitionBootstrapper(IIOManager ioManager) {
        if (!(ioManager instanceof AbstractCloudIOManager)) {
            throw new IllegalArgumentException("Not a cloud IOManager");
        }
        return (IPartitionBootstrapper)ioManager;
    }
}

