/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import org.apache.asterix.app.function.FunctionRewriter;
import org.apache.asterix.app.function.TPCDSAllTablesDataGeneratorDatasource;
import org.apache.asterix.metadata.declared.FunctionDataSource;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.UnnestingFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public class TPCDSAllTablesDataGeneratorRewriter
extends FunctionRewriter {
    public static final FunctionIdentifier TPCDS_ALL_TABLES_DATA_GENERATOR = new FunctionIdentifier("asterix", "tpcds-datagen", 1);
    public static final TPCDSAllTablesDataGeneratorRewriter INSTANCE = new TPCDSAllTablesDataGeneratorRewriter(TPCDS_ALL_TABLES_DATA_GENERATOR);

    private TPCDSAllTablesDataGeneratorRewriter(FunctionIdentifier functionId) {
        super(functionId);
    }

    @Override
    protected FunctionDataSource toDatasource(IOptimizationContext context, AbstractFunctionCallExpression function) throws AlgebricksException {
        UnnestingFunctionCallExpression functionCall = (UnnestingFunctionCallExpression)function;
        ConstantExpression scalingFactorArgument = (ConstantExpression)((Mutable)functionCall.getArguments().get(0)).getValue();
        IAObject scalingFactorArgumentValue = ((AsterixConstantValue)scalingFactorArgument.getValue()).getObject();
        IAType scalingFactorType = scalingFactorArgumentValue.getType();
        if (!ATypeHierarchy.canPromote((ATypeTag)scalingFactorType.getTypeTag(), (ATypeTag)ATypeTag.DOUBLE)) {
            throw new TypeMismatchException(this.getFunctionIdentifier(), 1, scalingFactorType.getTypeTag(), new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT, ATypeTag.FLOAT, ATypeTag.DOUBLE});
        }
        double scalingFactor = this.getScalingFactor(scalingFactorArgumentValue);
        return new TPCDSAllTablesDataGeneratorDatasource(context.getComputationNodeDomain(), scalingFactor, this.getFunctionIdentifier());
    }

    private double getScalingFactor(IAObject value) throws TypeMismatchException {
        switch (value.getType().getTypeTag()) {
            case TINYINT: {
                return ((AInt8)value).getByteValue();
            }
            case SMALLINT: {
                return ((AInt16)value).getShortValue();
            }
            case INTEGER: {
                return ((AInt32)value).getIntegerValue();
            }
            case BIGINT: {
                return ((AInt64)value).getLongValue();
            }
            case FLOAT: {
                return ((AFloat)value).getFloatValue();
            }
            case DOUBLE: {
                return ((ADouble)value).getDoubleValue();
            }
        }
        throw new TypeMismatchException(this.getFunctionIdentifier(), 1, value.getType().getTypeTag(), new ATypeTag[]{ATypeTag.TINYINT, ATypeTag.SMALLINT, ATypeTag.INTEGER, ATypeTag.BIGINT, ATypeTag.FLOAT, ATypeTag.DOUBLE});
    }

    private FunctionIdentifier getFunctionIdentifier() {
        return this.functionId;
    }
}

