/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.config;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;

public final class SerializedOption
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private final String sectionName;
    private final String optionName;

    SerializedOption(IOption option) {
        this.sectionName = option.section().name();
        this.optionName = option.name();
    }

    public String optionName() {
        return this.optionName;
    }

    public Section section() {
        return Section.valueOf(this.sectionName);
    }

    public int compareTo(Object o) {
        if (!(o instanceof SerializedOption)) {
            return -1;
        }
        SerializedOption that = (SerializedOption)o;
        int sectionComp = this.sectionName.compareTo(that.sectionName);
        return sectionComp != 0 ? sectionComp : this.optionName.compareTo(that.optionName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializedOption that = (SerializedOption)o;
        return Objects.equals(this.sectionName, that.sectionName) && Objects.equals(this.optionName, that.optionName);
    }

    public int hashCode() {
        return Objects.hash(this.sectionName, this.optionName);
    }

    public String toString() {
        return "[" + this.sectionName + "] " + this.optionName;
    }
}

