/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java.base;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.api.IJType;
import org.apache.asterix.external.library.java.base.JList;
import org.apache.asterix.external.library.java.base.JObject;
import org.apache.asterix.om.base.AMutableOrderedList;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public final class JOrderedList
extends JList<List<? extends Object>> {
    private AOrderedListType listType;

    public JOrderedList() {
        this((IAType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
    }

    public JOrderedList(IJType listItemType) {
        this.jObjects = new ArrayList();
        this.listType = new AOrderedListType(listItemType.getIAType(), null);
    }

    public JOrderedList(IAType listItemType) {
        this.jObjects = new ArrayList();
        this.listType = new AOrderedListType(listItemType, null);
    }

    @Override
    public List<? extends Object> getValueGeneric() {
        return (ArrayList)this.jObjects;
    }

    public List<IJObject> getValue() {
        return (List)this.jObjects;
    }

    @Override
    public IAType getIAType() {
        return this.listType;
    }

    @Override
    public IAObject getIAObject() {
        AMutableOrderedList v = new AMutableOrderedList(this.listType);
        for (IJObject jObj : this.jObjects) {
            v.add(jObj.getIAObject());
        }
        return v;
    }

    @Override
    public void setValueGeneric(List<? extends Object> vals) throws HyracksDataException {
        this.reset();
        if (vals.size() > 0) {
            Object first = vals.get(0);
            IAType iAType = JObject.convertType(first.getClass());
            IJObject obj = (IJObject)this.pool.allocate((Object)iAType);
            obj.setValueGeneric(first);
            IAType listType = obj.getIAType();
            this.listType = new AOrderedListType(listType, "");
        }
        for (Object object : vals) {
            IAType asxClass = JObject.convertType(object.getClass());
            IJObject obj = (IJObject)this.pool.allocate((Object)asxClass);
            obj.setValueGeneric(object);
            this.add(obj);
        }
    }

    @Override
    public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset((AbstractCollectionType)this.listType);
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        for (IJObject jObject : this.jObjects) {
            fieldValue.reset();
            jObject.serialize(fieldValue.getDataOutput(), writeTypeTag);
            listBuilder.addItem((IValueReference)fieldValue);
        }
        listBuilder.write(dataOutput, writeTypeTag);
    }

    @Override
    public void reset() {
        this.jObjects.clear();
    }
}

