/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.visitor.FreeVariableVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;

public class SqlppVariableUtil {
    private static final String USER_VAR_PREFIX = "$";
    private static final String EXTERNAL_VAR_PREFIX = "?";

    private SqlppVariableUtil() {
    }

    public static VarIdentifier toUserDefinedVariableName(VarIdentifier var) {
        String varName = var.getValue();
        return SqlppVariableUtil.toUserDefinedVariableName(varName);
    }

    public static VarIdentifier toUserDefinedVariableName(String varName) {
        if (varName.startsWith(USER_VAR_PREFIX)) {
            return new VarIdentifier(varName.substring(1));
        }
        return new VarIdentifier(varName);
    }

    public static String variableNameToDisplayedFieldName(String varName) {
        if (varName.startsWith(USER_VAR_PREFIX)) {
            return varName.substring(1);
        }
        return USER_VAR_PREFIX + varName.substring(1);
    }

    public static String toUserDefinedName(String varName) {
        if (varName.startsWith(USER_VAR_PREFIX)) {
            return varName.substring(1);
        }
        if (varName.startsWith(EXTERNAL_VAR_PREFIX)) {
            return varName.substring(1);
        }
        return varName;
    }

    public static String toInternalVariableName(String varName) {
        return USER_VAR_PREFIX + varName;
    }

    public static VarIdentifier toInternalVariableIdentifier(String idName) {
        return new VarIdentifier(SqlppVariableUtil.toInternalVariableName(idName));
    }

    public static String toExternalVariableName(String varName) {
        return EXTERNAL_VAR_PREFIX + varName;
    }

    public static boolean isPositionalVariableIdentifier(VarIdentifier varId) {
        try {
            Integer.parseInt(SqlppVariableUtil.toUserDefinedName(varId.getValue()));
            return true;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    public static boolean isExternalVariableIdentifier(VarIdentifier varId) {
        return varId.getValue().startsWith(EXTERNAL_VAR_PREFIX);
    }

    public static boolean isExternalVariableReference(VariableExpr varExpr) {
        return SqlppVariableUtil.isExternalVariableIdentifier(varExpr.getVar());
    }

    public static Set<VariableExpr> getFreeVariables(ILangExpression langExpr) throws CompilationException {
        HashSet<VariableExpr> freeVars = new HashSet<VariableExpr>();
        FreeVariableVisitor visitor = new FreeVariableVisitor();
        langExpr.accept((ILangVisitor)visitor, freeVars);
        return freeVars;
    }

    public static List<VariableExpr> getBindingVariables(FromClause fromClause) {
        if (fromClause == null) {
            return Collections.emptyList();
        }
        ArrayList<VariableExpr> bindingVars = new ArrayList<VariableExpr>();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            bindingVars.addAll(SqlppVariableUtil.getBindingVariables(fromTerm));
        }
        return bindingVars;
    }

    public static List<VariableExpr> getBindingVariables(FromTerm fromTerm) {
        ArrayList<VariableExpr> bindingVars = new ArrayList<VariableExpr>();
        if (fromTerm == null) {
            return bindingVars;
        }
        bindingVars.add(fromTerm.getLeftVariable());
        if (fromTerm.hasPositionalVariable()) {
            bindingVars.add(fromTerm.getPositionalVariable());
        }
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            bindingVars.add(correlateClause.getRightVariable());
            if (!correlateClause.hasPositionalVariable()) continue;
            bindingVars.add(correlateClause.getPositionalVariable());
        }
        return bindingVars;
    }

    public static List<VariableExpr> getBindingVariables(GroupbyClause gbyClause) {
        ArrayList<VariableExpr> bindingVars = new ArrayList<VariableExpr>();
        if (gbyClause == null) {
            return bindingVars;
        }
        HashSet<VariableExpr> gbyKeyVars = new HashSet<VariableExpr>();
        for (List gbyPairList : gbyClause.getGbyPairList()) {
            for (GbyVariableExpressionPair gbyKey : gbyPairList) {
                VariableExpr var = gbyKey.getVar();
                if (var == null || !gbyKeyVars.add(var)) continue;
                bindingVars.add(var);
            }
        }
        if (gbyClause.hasDecorList()) {
            for (GbyVariableExpressionPair gbyKey : gbyClause.getDecorPairList()) {
                VariableExpr var = gbyKey.getVar();
                if (var == null) continue;
                bindingVars.add(var);
            }
        }
        if (gbyClause.hasWithMap()) {
            bindingVars.addAll(gbyClause.getWithVarMap().values());
        }
        bindingVars.add(gbyClause.getGroupVar());
        return bindingVars;
    }

    public static List<VariableExpr> getLetBindingVariables(List<? extends AbstractClause> clauses) {
        ArrayList<VariableExpr> bindingVars = new ArrayList<VariableExpr>();
        if (clauses == null || clauses.isEmpty()) {
            return bindingVars;
        }
        for (AbstractClause abstractClause : clauses) {
            if (abstractClause.getClauseType() != Clause.ClauseType.LET_CLAUSE) continue;
            LetClause letClause = (LetClause)abstractClause;
            bindingVars.add(letClause.getVarExpr());
        }
        return bindingVars;
    }

    public static List<VariableExpr> getBindingVariables(QuantifiedExpression qe) {
        List quantifiedList = qe.getQuantifiedList();
        ArrayList<VariableExpr> bindingVars = new ArrayList<VariableExpr>(quantifiedList.size());
        for (QuantifiedPair qp : quantifiedList) {
            bindingVars.add(qp.getVarExpr());
        }
        return bindingVars;
    }

    public static void addToFieldVariableList(VariableExpr varExpr, List<Pair<Expression, Identifier>> outFieldList) {
        VarIdentifier var = varExpr.getVar();
        VariableExpr newVarExpr = new VariableExpr(var);
        newVarExpr.setSourceLocation(varExpr.getSourceLocation());
        outFieldList.add((Pair<Expression, Identifier>)new Pair((Object)newVarExpr, (Object)SqlppVariableUtil.toUserDefinedVariableName(var)));
    }

    public static LogicalVariable getVariable(ILogicalExpression expr) {
        return expr.getExpressionTag() == LogicalExpressionTag.VARIABLE ? ((VariableReferenceExpression)expr).getVariableReference() : null;
    }
}

