/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.utils;

import java.io.Serializable;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.nc.NodeControllerService;

public class NcLocalCounters
implements Serializable {
    private static final long serialVersionUID = 3798954558299915995L;
    private final long maxResourceId;
    private final long maxTxnId;
    private final long maxJobId;

    private NcLocalCounters(long maxResourceId, long maxTxnId, long maxJobId) {
        this.maxResourceId = maxResourceId;
        this.maxTxnId = maxTxnId;
        this.maxJobId = maxJobId;
    }

    public static NcLocalCounters collect(CcId ccId, NodeControllerService ncs) throws HyracksDataException {
        INcApplicationContext appContext = (INcApplicationContext)ncs.getApplicationContext();
        long maxResourceId = Math.max(appContext.getLocalResourceRepository().maxId(), 100L);
        long maxTxnId = appContext.getMaxTxnId();
        long maxJobId = ncs.getMaxJobId(ccId);
        return new NcLocalCounters(maxResourceId, maxTxnId, maxJobId);
    }

    public long getMaxResourceId() {
        return this.maxResourceId;
    }

    public long getMaxTxnId() {
        return this.maxTxnId;
    }

    public long getMaxJobId() {
        return this.maxJobId;
    }
}

